<?php

class WFCO_Kliksini_Get_Custom_Domain extends WFCO_Call {
	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'api_key' );
		$this->api_end_point   = ' https://ksni.my/api/domains'; // API URL
	}

	/**
	 * @return WFCO_Kliksini_Get_Custom_Domain|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		BWFCO_Kliksini::set_headers( $this->data['api_key'] );

		return $this->make_wp_requests( $this->api_end_point, array(), BWFCO_Kliksini::get_headers(), BWF_CO::$GET );
	}

}

return 'WFCO_Kliksini_Get_Custom_Domain';