<?php

class WFCO_Kliksini_Shorten_Url extends WFCO_Call {
	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'api_key', 'url' );
		$this->api_end_point   = 'https://ksni.my/api/url/add'; // API URL
	}

	/**
	 * @return WFCO_Kliksini_Shorten_Url|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'url'    => $this->data['url'],
			'domain' => $this->data['custom_domain']
		);

		BWFCO_Kliksini::set_headers( $this->data['api_key'] );

		return $this->make_wp_requests( $this->api_end_point, wp_json_encode( $params ), BWFCO_Kliksini::get_headers(), BWF_CO::$POST );
	}

}

return 'WFCO_Kliksini_Shorten_Url';