<?php

/**
 * Plugin Name:FunnelKit Automations Connectors Kliksini Addon
 * Plugin URI: https://buildwoofunnels.com
 * Description:Shorten the url with Autonami Marketing Automations Connectors - Kliksini
 * Version: 1.0.0
 * Author: WooFunnels
 * Author URI: https://buildwoofunnels.com
 * License: GPLv3 or later
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain: autonami-automations-pro
 */

final class WFCO_Kliksini {
	private static $_instance = null;

	private function __construct() {
		$this->define_plugin_properties();

		$this->load_hooks();
	}

	/**
	 * @return void
	 */
	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
	}

	/**
	 * initializing lms
	 * @return void
	 */
	public function define_plugin_properties() {
		define( 'WFCO_Kliksini_VERSION', '1.0.0' );
		define( 'WFCO_Kliksini_FULL_NAME', 'Autonami Marketing Automations Kliksini' );
		define( 'WFCO_Kliksini_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_Kliksini_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_Kliksini_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_Kliksini_PLUGIN_FILE ) ) );
	}

	public function load_hooks() {
		add_action( 'wfco_load_connectors', [ $this, 'load_connector_classes' ] );
	}

	/**
	 * Load Connector Classes
	 */
	public function load_connector_classes() {
		require_once( WFCO_Kliksini_PLUGIN_DIR . '/connector.php' );

		do_action( 'wfco_kliksini_connector_loaded', $this );
	}

}

WFCO_Kliksini::get_instance();

