<?php

class BWFCO_Kliksini extends BWF_CO {
	public static $headers = null;
	private static $ins = null;
	public $v2 = true;

	private function __construct() {
		$this->dir               = __DIR__;
		$this->is_setting        = true;
		$this->autonami_int_slug = 'kliksini_service';
		$this->connector_url     = WFCO_Kliksini_PLUGIN_URL;
		$this->nice_name         = __( 'Kliksini', 'autonami-automations-connectors' );

		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );

		/**
		 * adding this service to shortner services array using filter
		 */
		add_filter( 'bwfan_shortener_services', array( $this, 'add_as_shortner_service' ), 10, 1 );
	}

	public static function get_instance() {
		if ( is_null( self::$ins ) ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function set_headers( $api_key ) { // header is here 
		$headers = array(
			'Authorization' => 'Bearer ' . $api_key,
			'Content-Type'  => 'application/json',
		);

		self::$headers = $headers;
	}

	public static function get_headers() {
		return self::$headers;
	}

	/**
	 * @param $available_connectors
	 * this function create the connector view under connectors tab
	 *
	 * @return mixed
	 */
	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_kliksini'] = array(
			'name'            => 'Kliksini',
			'desc'            => __( 'Shorten the URLs to reduce the character limit for SMS.', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFAN_Service_Kliksini',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	/**
	 * @param $link
	 * every shortner service connector should contain this function
	 *
	 * this function returns the shorter link
	 *
	 * @return mixed|string
	 */
	public function generate_shorten_url( $link ) {
		if ( '' === $link ) {
			return '';
		}
		$link = trim( $link );

		if ( false === filter_var( $link, FILTER_VALIDATE_URL ) ) {
			return $link;
		}

		$data = WFCO_Common::$connectors_saved_data;

		if ( ! array_key_exists( 'bwfco_kliksini', $data ) ) {
			return $link;
		}

		$kliksini_settings = $data['bwfco_kliksini'];

		$data = array(
			'api_key' => isset( $kliksini_settings['api_key'] ) ? $kliksini_settings['api_key'] : '',
			'url'     => $link
		);

		if ( isset( $kliksini_settings['default_domain'] ) && ! empty( $kliksini_settings['default_domain'] ) ) {
			$default       = $kliksini_settings['default_domain'];
			$custom_domain = isset( $kliksini_settings['custom_domain'] ) && ! empty( $kliksini_settings['custom_domain'] ) && isset( $kliksini_settings['custom_domain'][ $default ] ) ? $kliksini_settings['custom_domain'][ $default ] : '';
			if ( ! empty( $custom_domain ) ) {
				$data['custom_domain'] = $custom_domain;
			}
		}

		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_kliksini_shorten_url' );

		if ( is_null( $call_class ) ) {
			return $link;
		}

		$call_class->set_data( $data );
		$shorten_res = $call_class->process();

		if ( is_array( $shorten_res ) && 200 === $shorten_res['response'] ) {
			$link2 = str_replace('https://','',$shorten_res['body']['shorturl']);
			$link  = empty( $link2 ) ? $link : $link2;
		}

		return $link;
	}

	/**
	 * @return array[]
	 * this function is used to define form fields for view settings
	 */
	public function get_fields_schema() {
		$api_key_schema = $this->get_api_key_schema();

		/** Send Only API Key Schema, if only API Key Available */
		$settings = $this->get_settings_fields_values();
		if ( empty( $settings ) || ! isset( $settings['default_domain'] ) ) {
			return array( $api_key_schema );
		}

		return array(
			$api_key_schema,
			$this->get_custom_domain_schema_with_old_custom_domain_options(),
		);

	}

	public function get_meta_data() {
		return array(
			'connect_type' => 'wizard',
		);
	}

	/**
	 * Return true means all values are available, Now just run the handle_settings_form
	 */
	public function get_next_step( $values ) {
		if ( empty( $values ) || ! isset( $values['api_key'] ) || empty( $values['api_key'] ) ) {
			return BWFCRM_Common::crm_error( __( 'API Key is not provided', 'autonami-automations-connectors' ) );
		}

		/** Return domain options */
		if ( ! isset( $values['default_domain'] ) || empty( $values['default_domain'] ) ) {
			$custom_domain = $this->fetch_custom_domain( $values );
			if ( is_array( $custom_domain ) && isset( $custom_domain['status'] ) && 'failed' === $custom_domain['status'] ) {
				return BWFCRM_Common::crm_error( $custom_domain['message'] );
			}
 
			if ( ! is_array( $custom_domain ) || 0 === count( $custom_domain ) ) {
				$custom_domain = "Not Available";
	//			return BWFCRM_Common::crm_error( __( 'No Custom Domain found to select', 'autonami-automations-connectors' ) );
			}

			return array( $this->get_custom_domain_schema( $custom_domain ) );
		}

		return true;
	}

	/**
	 * Fetch domains
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_custom_domain( $params, $captured_items = array() ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\Mautic\Get_Contact_Fields $call */
		$call = $connectors->get_call( 'wfco_kliksini_get_custom_domain' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 200 !== absint( $result['response'] ) ) {
			$error = __( 'Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'] . __( '. Kliksini Error: ', 'autonami-automations-connectors' );
			$error .= isset( $result['body']['error'] ) && 1 === intval( $result['body']['error'] ) ? $result['body']['message'] : __( 'No Response from Kliksini. ', 'autonami-automations-connectors' );

			return array(
				'status'   => 'failed',
				'api_data' => $params,
				'message'  => $error,
			);
		}

		if ( ! isset( $result['body']['data']['domains'] ) || empty( $result['body']['data']['domains'] ) ) {
			return array();
		}

		$data = $result['body']['data']['domains'];
		foreach ( $data as $row ) {
			$id                    = $row['id'];
			$captured_items[ $id ] = $row['domain'];
		}

		return $captured_items;
	}

	public function get_api_key_schema() {
		return array(
			'id'          => 'api_key',
			'label'       => __( 'Api Key', 'wp-marketing-automations-connectors' ),
			'type'        => 'text',
			'class'       => 'bwfan_bg_api_key',
			'placeholder' => __( 'Api Key', 'wp-marketing-automations-connectors' ),
			'required'    => true,
			'toggler'     => array(),
		);
	}

	public function get_custom_domain_schema_with_old_custom_domain_options() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();
		if ( ! isset( $old_data['custom_domain'] ) ) {
			return array();
		}

		return $this->get_custom_domain_schema( $old_data['custom_domain'] );
	}

	public function get_custom_domain_schema( $custom_domain ) {

		$options = array(
			array(
				'label' => __( 'Select Domain', 'autonami-automations-connectors' ),
				'value' => '',
			),
		);

		$options[] = array(
			'label' => 'ksni.my',
			'value' => 'ksni.my'
		);

		foreach ( $custom_domain as $id => $name ) {
			$options[] = array(
				'label' => $name,
				'value' => $id,
			);
		}

		return array(
			'id'       => 'default_domain',
			'type'     => 'wp_select',
			'label'    => __( 'Select Domain', 'autonami-automations-connectors' ),
			'class'    => 'bwfan_kliksini_custom_domain',
			'required' => true,
			'options'  => $options,
		);
	}

	/**
	 * @return array
	 * this function used to get the form field value if any
	 */
	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();
		$vals       = array();
		if ( isset( $old_data['api_key'] ) ) {
			$vals['api_key'] = $old_data['api_key'];
		}

		if ( isset( $old_data['default_domain'] ) ) {
			$vals['default_domain'] = $old_data['default_domain'];
		}

		return $vals;
	}

	public function get_initial_schema() {
		return array(
			$this->get_api_key_schema(),
		);
	}

	/**
	 * Get data from the API call, must required function otherwise call
	 *
	 * @param $posted_data
	 *
	 * @return array
	 */
	protected function get_api_data( $posted_data ) {
		$resp_array     = array();
		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_kliksini_shorten_url' );

		$resp_array = array(
			'api_data' => $posted_data,
			'status'   => 'failed',
			'message'  => __( 'There is problem authenticating your account. Confirm entered details.', 'autonami-automations-connectors' ),
		);

		if ( is_null( $call_class ) ) {
			return $resp_array;
		}

		$resp_array['api_data']['default_domain'] = isset( $posted_data['default_domain'] ) ? $posted_data['default_domain'] : '';

		$data = array(
			'api_key'       => isset( $posted_data['api_key'] ) ? $posted_data['api_key'] : '',
			'custom_domain' => isset( $posted_data['default_domain'] ) ? $posted_data['default_domain'] : '',
			'url'           => site_url()
		);

		$call_class->set_data( $data );
		$result = $call_class->process();

		if ( is_array( $result ) && 200 === $result['response'] && is_array( $result['body'] ) ) {
			$resp_array['status']              = 'success';
			$resp_array['api_data']['api_key'] = $posted_data['api_key'];

			/** Fetch Custom Fields */
			$custom_domains_result = $this->fetch_custom_domain( $data );
			if ( is_array( $custom_domains_result ) && count( $custom_domains_result ) > 0 ) {
				$resp_array['api_data']['custom_domain'] = $custom_domains_result;
			}

			return $resp_array;
		}

		if ( 403 === $result['response'] && 1 === intval( $result['body']['error'] ) ) {
			$resp_array['status']   = 'failed';
			$resp_array['message']  = isset( $result['body']['message'] ) ? $result['body']['message'] : __( 'Undefined Api Error', 'autonami-automations-connectors' );
			$resp_array['api_data'] = array();

			return $resp_array;
		}

		$resp_array['status']   = 'failed';
		$resp_array['message']  = isset( $result['body']['message'] ) ? $result['body']['message'] : __( 'Unknown Api Error', 'autonami-automations-connectors' );
		$resp_array['api_data'] = array();

		return $resp_array;
	}

	/**
	 * Add this integration to Shortner services list.
	 *
	 * @param $shortner_services
	 *
	 * @return array
	 */
	public function add_as_shortner_service( $shortner_services ) {
		$slug = $this->get_slug();

		if ( BWFAN_Core()->connectors->is_connected( $slug ) ) {
			$shortner_services[ $slug ] = $this->nice_name;
		}

		return $shortner_services;
	}

}

WFCO_Load_Connectors::register( 'BWFCO_Kliksini' );