<?php

#[AllowDynamicProperties]
class BWFCO_Bulkgate extends BWF_CO {
	public static $headers = null;
	private static $ins = null;
	public $v2 = true;

	public function __construct() {

		$this->sync = false;

		/**
		 * Load important variables and constants
		 */
		$this->define_plugin_properties();

		/**
		 * Loads common file
		 */
		$this->init_bulkgate();


		/** Connector.php initialization */
		$this->keys_to_track = [
			'application_id',
			'application_token',
			'sender_id',
		];
		$this->form_req_keys = [
			'application_id',
			'application_token',
		];

		$this->sync          = false;
		$this->connector_url = WFCO_BULKGATE_PLUGIN_URL;
		$this->dir           = __DIR__;
		$this->nice_name     = __( 'Bulkgate', 'autonami-automations-connectors' );

		$this->autonami_int_slug = 'BWFAN_Bulkgate_Integration';

		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );

		/**
		 * adding this services using filter
		 */
		add_filter( 'bwfan_shortener_services', array( $this, 'add_as_shortener_service' ), 10, 1 );
	}

	public function get_fields_schema() {
		return array(
			array(
				'id'          => 'application_id',
				'label'       => __( 'Application ID', 'autonami-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_bg_application_id',
				'placeholder' => __( 'Application ID', 'autonami-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			),
			array(
				'id'          => 'application_token',
				'label'       => __( 'Application Token', 'autonami-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_bg_application_token',
				'placeholder' => __( 'Application Token', 'autonami-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			),
			array(
				'id'          => 'sender_id',
				'label'       => __( 'Sender ID', 'autonami-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_bg_sender_id',
				'placeholder' => __( 'Sender ID', 'autonami-automations-connectors' ),
				'required'    => false,
				'toggler'     => array(),
			),
		);
	}

	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();
		$vals       = array();
		if ( isset( $old_data['application_id'] ) ) {
			$vals['application_id'] = $old_data['application_id'];
		}
		if ( isset( $old_data['application_token'] ) ) {
			$vals['application_token'] = $old_data['application_token'];
		}

		if ( isset( $old_data['sender_id'] ) ) {
			$vals['sender_id'] = $old_data['sender_id'];
		}

		return $vals;
	}

	/**
	 * Defining constants
	 */
	public function define_plugin_properties() {
		define( 'WFCO_BULKGATE_VERSION', '1.0.0' );
		define( 'WFCO_BULKGATE_FULL_NAME', 'FunnelKit Automations Connectors: BulkGate' );
		define( 'WFCO_BULKGATE_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_BULKGATE_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_BULKGATE_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_BULKGATE_PLUGIN_FILE ) ) );
		define( 'WFCO_BULKGATE_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_BULKGATE_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_BULKGATE_ENCODE', sha1( WFCO_BULKGATE_PLUGIN_BASENAME ) );
	}

	public function init_bulkgate() {
		require WFCO_BULKGATE_PLUGIN_DIR . '/includes/class-wfco-bulkgate-call.php';
	}

	/**
	 * Get data from the API call, must required function otherwise call
	 *
	 * @param $posted_data
	 *
	 * @return array
	 */
	protected function get_api_data( $posted_data ) {
		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_bulkgate_oauth_check' );

		$resp_array = array(
			'api_data' => $posted_data,
			'status'   => 'failed',
			'message'  => __( 'There is problem authenticating your account. Confirm entered details.', 'autonami-automations-connectors' ),
		);

		if ( is_null( $call_class ) ) {
			return $resp_array;
		}

		$data = array(
			'application_id'    => isset( $posted_data['application_id'] ) ? $posted_data['application_id'] : '',
			'application_token' => isset( $posted_data['application_token'] ) ? $posted_data['application_token'] : '',
			'sender_id'         => isset( $posted_data['sender_id'] ) ? $posted_data['sender_id'] : ''
		);

		$call_class->set_data( $data );
		$ac_status = $call_class->process();


		if ( is_array( $ac_status ) && 200 === $ac_status['response'] && isset( $ac_status['body'] ) ) {
			$response                                  = [];
			$response['status']                        = 'success';
			$response['api_data']['application_id']    = $posted_data['application_id'];
			$response['api_data']['application_token'] = $posted_data['application_token'];
			$response['api_data']['sender_id']         = isset( $posted_data['sender_id'] ) ? $posted_data['sender_id'] : '';

			return $response;
		} else {
			$resp_array['status']   = 'failed';
			$resp_array['message']  = isset( $ac_status['body']['error'] ) ? $ac_status['body']['error'] : __( 'Undefined Api Error', 'autonami-automations-connectors' );
			$resp_array['api_data'] = array();

			return $resp_array;
		}
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function set_headers() {
		$headers = array(
			'Host'          => 'portal.bulkgate.com',
			'Content-Type'  => 'application/json',
			'Cache-Control' => 'no-cache'
		);

		self::$headers = $headers;
	}

	public static function get_headers() {
		return self::$headers;
	}

	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_bulkgate'] = array(
			'name'            => 'Bulkgate',
			'desc'            => __( 'Send simple transactional sms', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFCO_Bulkgate',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	/**
	 * Generate shortener link
	 *
	 * @param $link
	 *
	 * @return mixed|string
	 */
	public function generate_shorten_url( $link ) {
		$link = trim( $link );
		if ( empty( $link ) ) {
			return '';
		}

		if ( false === filter_var( $link, FILTER_VALIDATE_URL ) ) {
			return $link;
		}

		$data = WFCO_Common::$connectors_saved_data;

		if ( empty( $data ) || ! array_key_exists( 'bwfco_bulkgate', $data ) ) {
			return $link;
		}

		$settings = $data['bwfco_bulkgate'];

		$data = array(
			'application_id'    => isset( $settings['application_id'] ) ? $settings['application_id'] : '',
			'application_token' => isset( $settings['application_token'] ) ? $settings['application_token'] : '',
			'url'               => $link
		);

		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_bulkgate_shorten_url' );

		if ( is_null( $call_class ) ) {
			return $link;
		}

		$call_class->set_data( $data );
		$shorten_res = $call_class->process();

		if ( is_array( $shorten_res ) && 200 === $shorten_res['response'] ) {
			$link = $shorten_res['body']['data']['short_url'];
		}

		return $link;
	}

	/**
	 * Add this integration to Shortener services list.
	 *
	 * @param $services
	 *
	 * @return array
	 */
	public function add_as_shortener_service( $services ) {
		$slug = $this->get_slug();

		if ( BWFAN_Core()->connectors->is_connected( $slug ) ) {
			$services[ $slug ] = $this->nice_name;
		}

		return $services;
	}
}

WFCO_Load_Connectors::register( 'BWFCO_Bulkgate' );
