<?php

#[AllowDynamicProperties]
final class BWFAN_GR_Add_Tags extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Add Tags', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action adds the selected tags to the contact', 'autonami-automations-connectors' );
		$this->action_priority = 30;
		$this->support_v2      = true;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'tags_options', $data['tags'] );
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'list_options', $data['lists'] );
		}
	}

	public function get_view_data() {
		$lists = WFCO_Common::get_single_connector_data( $this->connector, 'lists' );
		$tags  = WFCO_Common::get_single_connector_data( $this->connector, 'tags' );

		return [ 'tags' => $tags, 'lists' => $lists ];
	}

	/**
	 * Show the html fields for the current action.
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            selected_list = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'list_id')) ? data.actionSavedData.data.list_id : '';
            selected_tags = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'tags')) ? data.actionSavedData.data.tags : {};

            if(_.has(data.actionFieldsOptions, 'tags_options') && _.isObject(data.actionFieldsOptions.tags_options) ) {
            tags_options_clone = data.actionFieldsOptions.tags_options;

            if( _.size(selected_tags) > 0 ) {
            diffTags = _.difference(selected_tags,_.keys(tags_options_clone));

            if(_.size(diffTags) > 0) {
            _.each( diffTags, function( value, key ){
            tags_options_clone[value] = value;
            });

            }
            }
            }
            #>
            <label for="" class="bwfan-label-title">
				<?php
				echo esc_html__( 'Add Tags', 'autonami-automations-connectors' );
				$message = __( 'Add available tags and if unable to locate then sync the connector.', 'autonami-automations-connectors' );
				echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
				echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput
				?>
            </label>
            <div class="bwfan_add_tags">
                <div class="bwfan_tags_wrap">
                    <input list="tags" type="text" id="new-tag-bwfan_tag" class="bwfan-input-wrapper" autocomplete="on">
                    <input type="button" class="button bwfan-tag-add" value="Add">
                </div>
                <ul class="tagchecklist" role="list"></ul>
                <select style="display: none" name="bwfan[{{data.action_id}}][data][tags][]" multiple class="bwfan_add_tags_final_value" data-name="tags" data-action="<?php echo $unique_slug ?>">
                </select>
            </div>
            <div class="bwfan-col-sm-12 bwfan-p-0 bwfan-mb-15">
                <label class="bwfan-label-title">Select List</label>
                <div>
                    <select required id="" class="bwfan-input-wrapper" name="bwfan[{{data.action_id}}][data][list_id]">
                        <option value=""><?php echo esc_html__( 'Default List', 'autonami-automations-connectors' ); ?></option>
                        <#
                        if(_.has(data.actionFieldsOptions, 'list_options') && _.isObject(data.actionFieldsOptions.list_options) ) {
                        _.each( data.actionFieldsOptions.list_options, function( value, key ){
                        selected = (key == selected_list) ? 'selected' : '';
                        #>
                        <option value="{{key}}" {{selected}}>{{value}}</option>
                        <# })
                        }
                        #>
                    </select>
                </div>
                <div class="bwfan_field_desc bwfan-mb10">Select the list to update tags in.</div>
            </div>
        </script>
		<?php
	}

	/**
	 * Overrides the parent class method to return new array type values
	 *
	 * @param $dynamic_array
	 * @param $integration_data
	 *
	 * @return array
	 */
	public function parse_merge_tags( $dynamic_array, $integration_data ) {
		return $this->parse_tags_fields( $dynamic_array, $integration_data );
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$this->is_action_tag    = true;
		$data_to_set            = array();
		$data_to_set['api_key'] = $integration_object->get_settings( 'api_key' );
		$data_to_set['list_id'] = empty( $task_meta['data']['list_id'] ) ? $integration_object->get_settings( 'default_list' ) : $task_meta['data']['list_id'];

		/** Set Email if global email is empty */
		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		/** Decode Merge Tags in GetResponse Tags */
		$final_tags      = [];
		$user_input_tags = $task_meta['data']['tags'];
		foreach ( $user_input_tags as $tag_value ) {
			$tags_response = BWFAN_Common::decode_merge_tags( $tag_value );
			$tags          = json_decode( $tags_response );
			if ( is_array( $tags ) && count( $tags ) > 0 ) {
				foreach ( $tags as $single_tag ) {
					$final_tags[] = $single_tag;
				}
				continue;
			}
			$final_tags[] = $tags_response;
		}

		/** Separate already created tags from new tags to make */
		$new_tags_to_make     = [];
		$tags_already_created = [];
		$tags_in_settings     = $integration_object->get_settings( 'tags' );
		foreach ( $final_tags as $tag_value ) {
			/** If nothing in DB */
			if ( empty( $tags_in_settings ) ) {
				$new_tags_to_make = $final_tags;
				break;
			}

			/** tag value is tag id and is available */
			if ( isset( $tags_in_settings[ $tag_value ] ) ) {
				$tags_already_created[] = $tag_value;
				continue;
			}

			/** If tag value found in saved tags, append proper tag id */
			$saved_tag_id = array_search( $tag_value, $tags_in_settings );
			if ( false !== $saved_tag_id ) {
				$tags_already_created[] = $saved_tag_id;
				continue;
			}

			/** Else new tag */
			$new_tags_to_make[] = $tag_value;
		}

		$data_to_set['tags'] = array(
			'new'      => $new_tags_to_make,
			'existing' => $tags_already_created
		);

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set            = array();
		$final_tags             = array();
		$data_to_set['api_key'] = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$defaulet_list          = isset( $step_data['connector_data']['default_list'] ) ? $step_data['connector_data']['default_list'] : '';
		$data_to_set['list_id'] = empty( $step_data['list_id'] ) ? $defaulet_list : $step_data['list_id'];
		$user_input_tags        = $step_data['tags'];
		$data_to_set['email']   = $automation_data['global']['email'];

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		foreach ( $user_input_tags as $tag ) {
			$tag_value     = isset( $tag['id'] ) && empty( absint( $tag['id'] ) ) ? $tag['name'] : $tag['id'];
			$tags_response = BWFAN_Common::decode_merge_tags( $tag_value );

			$final_tags[] = $tags_response;
		}

		/** Separate already created tags from new tags to make */
		$new_tags_to_make     = [];
		$tags_already_created = [];
		$tags_in_settings     = isset( $step_data['connector_data']['tags'] ) ? $step_data['connector_data']['tags'] : '';
		foreach ( $final_tags as $tag_value ) {
			/** If nothing in DB */
			if ( empty( $tags_in_settings ) ) {
				$new_tags_to_make = $final_tags;
				break;
			}

			/** tag value is tag id and is available */
			if ( isset( $tags_in_settings[ $tag_value ] ) ) {
				$tags_already_created[] = $tag_value;
				continue;
			}

			/** If tag value found in saved tags, append proper tag id */
			$saved_tag_id = array_search( $tag_value, $tags_in_settings );
			if ( false !== $saved_tag_id ) {
				$tags_already_created[] = $saved_tag_id;
				continue;
			}

			/** Else new tag */
			$new_tags_to_make[] = $tag_value;
		}

		$data_to_set['tags'] = array(
			'new'      => $new_tags_to_make,
			'existing' => $tags_already_created
		);

		return $data_to_set;
	}

	protected function handle_response( $result, $call_object = null ) {
		if ( isset( $result['status'] ) ) {
			return $result;
		}

		if ( isset( $result['body']['code'] ) ) {
			return array(
				'status'  => 4,
				'message' => __( 'Error: ' . $result['body']['message'], 'autonami-automations-connectors' ),
			);
		}

		if ( isset( $result['response'] ) && 200 !== absint( $result['response'] ) ) {
			$message = ( 502 === absint( $result['response'] ) ) ? $result['body'][0] : __( 'Unknown Error Occurred', 'autonami-automations-connectors' );

			return array(
				'status'  => 4,
				'message' => __( $message, 'autonami-automations-connectors' ),
			);
		}

		if ( isset( $result['response'] ) && 200 === absint( $result['response'] ) ) {
			return array(
				'status'  => 3,
				'message' => isset( $result['body']['result_message'] ) ? $result['body']['result_message'] : __( 'Tags added successfully!', 'autonami-automations-connectors' ),
			);
		}

		BWFAN_Core()->logger->log( $result, 'failed-' . $this->get_slug() . '-action' );

		return array(
			'status'  => 4,
			'message' => __( 'Unknown Error: Check log failed-' . $this->get_slug() . '-action', 'autonami-automations-connectors' ),
		);
	}

	public function handle_response_v2( $result ) {
		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		if ( isset( $result['body']['code'] ) ) {
			return $this->error_response( __( 'Error: ' . $result['body']['message'], 'autonami-automations-connectors' ) );
		}

		if ( isset( $result['response'] ) && 200 !== absint( $result['response'] ) ) {
			$message = ( 502 === absint( $result['response'] ) ) ? $result['body'][0] : __( 'Unknown Error Occurred', 'autonami-automations-connectors' );

			return $this->error_response( __( $message, 'autonami-automations-connectors' ) );
		}

		if ( isset( $result['response'] ) && 200 === absint( $result['response'] ) ) {
			return $this->success_message( isset( $result['body']['result_message'] ) ? $result['body']['result_message'] : __( 'Tags added successfully!', 'autonami-automations-connectors' ) );
		}

		BWFAN_Core()->logger->log( $result, 'failed-' . $this->get_slug() . '-action' );

		return $this->error_response( __( 'Unknown Error: Check log failed-' . $this->get_slug() . '-action', 'autonami-automations-connectors' ) );
	}

	public function before_executing_task() {
		add_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10, 1 );
	}

	public function after_executing_task() {
		remove_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10 );
	}

	public function return_confirmation( $bool ) {
		if ( $this->is_action_tag ) {
			$bool = true;
		}

		return $bool;
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$data  = $this->get_view_data();
		$lists = isset( $data['lists'] ) && is_array( $data['lists'] ) && ! empty( $data['lists'] ) ? BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $data['lists'] ) ) : [];

		return [
			[
				"id"                  => 'tags',
				"label"               => __( 'Add Tags', 'autonami-automations-connectors' ),
				"type"                => 'custom_search',
				'autocompleterOption' => [
					'path'      => 'gr_tags',
					'slug'      => 'gr_tags',
					'labelText' => 'tag'
				],
				"allowFreeTextSearch" => true,
				"required"            => true,
				"tip"                 => __( "Add available tags and if unable to locate then sync the connector.", 'autonami-automations-connectors' ),
			],
			[
				'id'          => 'list_id',
				'label'       => __( "Select List", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $lists,
				'placeholder' => "Choose A List",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => 'Select the list to update tags in.',
				"required"    => true,
			],
		];
	}

	/**
	 * v2 Methods: Get field options
	 *
	 * @param string $search
	 * @param string $identifier
	 *
	 * @return array|mixed
	 */
	public function get_options( $search = '', $identifier = '' ) {
		$data       = $this->get_view_data();
		$final_data = 'lists' === $identifier ? $data['lists'] : $data['tags'];

		if ( empty( $search ) ) {
			return $final_data;
		}

		return array_filter( $final_data, function ( $data ) use ( $search ) {
			return false !== strpos( strtolower( $data ), strtolower( $search ) );
		} );
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['tags'] ) || empty( $data['tags'] ) ) {
			return '';
		}

		$tags = [];
		foreach ( $data['tags'] as $tag ) {
			if ( ! isset( $tag['name'] ) || empty( $tag['name'] ) ) {
				continue;
			}
			$tags[] = $tag['name'];
		}

		return $tags;
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_GR_Add_Tags';
