<?php

namespace WFCO\GetResponse;

#[\AllowDynamicProperties]
class Create_Contact extends \WFCO_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'api_key', 'email', 'list_id' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gr_create_contact';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		if ( ! is_email( $this->data['email'] ) ) {
			return array(
				'response' => 502,
				'body'     => array( 'Email is not valid' ),
			);
		}

		\BWFCO_GetResponse::set_headers( $this->data['api_key'] );

		$this->data['campaign'] = array(
			'campaignId' => $this->data['list_id']
		);

		$first_name = isset( $this->data['first_name'] ) ? $this->data['first_name'] : '';
		$last_name  = isset( $this->data['last_name'] ) ? $this->data['last_name'] : '';
		if ( ! empty( $first_name ) || ! empty( $last_name ) ) {
			$this->data['name'] = $first_name . ' ' . $last_name;
		}

		unset( $this->data['api_key'] );
		unset( $this->data['list_id'] );
		unset( $this->data['first_name'] );
		unset( $this->data['last_name'] );
		$this->data['bwfan_con_source'] = 'autonami';

		return $this->make_wp_requests( $this->get_endpoint(), wp_json_encode( $this->data ), \BWFCO_GetResponse::get_headers(), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		return \BWFCO_GetResponse::get_endpoint() . 'contacts';
	}

}

return 'WFCO\GetResponse\Create_Contact';
