<?php

#[AllowDynamicProperties]
class BWFAN_GS_Delete_Data extends BWFAN_Action {

	private static $instance = null;

	public function __construct() {
		$this->action_name = __( 'Delete Row', 'autonami-automations-connectors' );
		$this->support_v2  = true;
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$integration_data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'worksheet_column_options', $integration_data );
		}
	}

	public function get_view_data() {
		return BWFAN_Google_Sheets_Integration::get_a_z_columns_view();
	}

	public function get_view() {
		$unique_slug = $this->get_slug();
		?>

        <script type="text/html" id="tmpl-action-<?php echo $unique_slug; ?>">
            <#
            spreadsheet_id = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'spreadsheet_id')) ? data.actionSavedData.data.spreadsheet_id : '';
            worksheet_title = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'worksheet_title')) ? data.actionSavedData.data.worksheet_title : '';
            worksheets_log = data.actionFieldsOptions.worksheet_column_options;
            if(_.has(data.actionSavedData, 'ajax-data') && _.has(data.actionSavedData['ajax-data'], 'worksheet_title_column') &&
            _.isObject(data.actionSavedData['ajax-data'].worksheet_title_column) ) {
            _.each( data.actionSavedData['ajax-data'].worksheet_title_column, function( value, key ){
            if(_.size(value) > 26){
            worksheets_log = (key == worksheet_title) ? value: worksheets_log;
            }
            })
            }
            if(_.has(data.actionFieldsOptions, 'worksheet_column_options') && _.isObject(data.actionFieldsOptions.worksheet_column_options) ) {
            data.actionFieldsOptions.worksheet_column_options = worksheets_log;
            }
            #>
            <div class="bwfan-input-form clearfix">
                <label for="" class="bwfan-label-title"><?php echo __( 'Enter Google SpreadSheet ID', 'autonami-automations-connectors' ); ?></label>
                <div class="bwfan-col-sm-9 bwfan-pl-0">
                    <input required type="text" value="{{spreadsheet_id}}" class="bwfan-input-wrapper wfco_gs_get_spreadsheet_id" name="bwfan[{{data.action_id}}][data][spreadsheet_id]"/>
                </div>
                <div class="bwfan-col-sm-3 bwfan-pl-0">
                    <a href="#" class="button wfco_<?php echo $unique_slug; ?>_get_worksheets"><?php echo __( 'Get Sheets', 'autonami-automations-connectors' ); ?></a>
                </div>
            </div>

            <# if('' != spreadsheet_id && _.has(data.actionSavedData, 'ajax-data') && '<?php echo $unique_slug; ?>'===data.actionSavedData.action_slug){ #>
            <input type="hidden" name="bwfan[{{data.action_id}}][ajax-data]" value="{{JSON.stringify(data.actionSavedData['ajax-data'])}}"/>
            <div class="bwfan-input-form clearfix">
                <label for="" class="bwfan-label-title">
					<?php
					echo __( 'Select Worksheet', 'autonami-automations-connectors' );
					$message = __( 'Select work sheet where data needs to delete.', 'autonami-automations-connectors' );
					echo $this->add_description( $message );
					?>
                </label>
                <div class="bwfan-col-sm-12 bwfan-pl-0">
                    <select class="bwfan-input-wrapper" id="wfco_delete_select_worksheet" name="bwfan[{{data.action_id}}][data][worksheet_title]">
                        <#
                        if(_.has(data.actionSavedData, 'ajax-data') && _.has(data.actionSavedData['ajax-data'], 'worksheet_title_options') &&
                        _.isObject(data.actionSavedData['ajax-data'].worksheet_title_options) ) {
                        _.each( data.actionSavedData['ajax-data'].worksheet_title_options, function( value, key ){
                        selected = (value == worksheet_title) ? 'selected' : '';
                        #>
                        <option value="{{value}}" {{selected}}>{{value}}</option>
                        <# })
                        }
                        #>
                    </select>
                </div>
            </div>

            <label for="" class="bwfan-label-title">
				<?php
				echo __( 'Row to delete for a given column value', 'autonami-automations-connectors' );
				echo $this->inline_merge_tag_invoke();
				?>
            </label>
            <div class="clearfix bwfan-input-search">
                <#
                searchArr = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'worksheet_search_data')) ? data.actionSavedData.data.worksheet_search_data : {};
                searchCount = _.size(searchArr.column);
                if(searchCount == 0) {
                searchArr = {column:{0:''}, value:{0:''}};
                }
                #>
                <div class="bwfan-input-form clearfix gs-search-fields gs-delete-search-fields">
                    <div class="bwfan-col-sm-3 bwfan-pl-0">
                        <select data-element-type="bwfan-select" data-parent-groupid="{{data.action_id}}" data-parent-slug="<?php echo $unique_slug; ?>" required
                                class="bwfan-field-select bwfan-input-wrapper gs-delete-column-option" name="bwfan[{{data.action_id}}][data][worksheet_search_data][column][0]">
                            <#
                            if(_.has(data.actionFieldsOptions, 'worksheet_column_options') && _.isObject(data.actionFieldsOptions.worksheet_column_options) ) {
                            _.each( data.actionFieldsOptions.worksheet_column_options, function( search_column_option_value, search_column_option_key ){
                            selected = (search_column_option_key == searchArr.column[0]) ? 'selected' : '';
                            #>
                            <option value="{{search_column_option_key}}" {{selected}}>{{search_column_option_value}}</option>
                            <# })
                            }
                            #>
                        </select>
                    </div>
                    <div class="bwfan-col-sm-9 bwfan-p-0">
                        <input required type="text" placeholder="Value for search" class="bwfan-input-wrapper bwfan-input-merge-tags" value="{{searchArr.value[0]}}" name="bwfan[{{data.action_id}}][data][worksheet_search_data][value][0]"/>
                    </div>
                </div>
            </div>
            <# } #>
        </script>

        <script>
            jQuery(document).ready(function ($) {
                /** Fetch all worksheets of a given spreadsheet id */
                $('body').on('click', '.wfco_<?php echo $unique_slug; ?>_get_worksheets', function (event) {
                    event.preventDefault();
                    var $this = $(this);
                    var spreadsheet_id = $this.parent().parent().find('.wfco_gs_get_spreadsheet_id').val();
                    var error_generated;

                    /** Check if spreadsheet id is provided or not */
                    if (typeof spreadsheet_id == 'undefined' || '' === spreadsheet_id) {

                        error_generated = $this.parent().parent().parent().find('div.error.wfco_error').html();
                        if ('undefined' == typeof error_generated) {
                            $this.parent().parent().after("<div class='error wfco_error'></div>");
                        }

                        $('.error.wfco_error').fadeIn().html('<?php echo __( 'Please enter spreadsheet Id', 'autonami-automations-connectors' ); ?>');
                        setTimeout(function () {
                            $('.error.wfco_error').fadeOut("slow");
                        }, 2500);

                        return;
                    }

                    $this.addClass('wfco_loading');
                    $this.parent().parent().after('<img style="padding:4px 0 0 5px" class="wp_spinner_gif" src="<?php echo includes_url() . 'images/spinner.gif'; ?>">');
                    var worksheet_title = $this.closest('#bwfan-actions-form').find('#wfco_delete_select_worksheet').val();
                    if (typeof worksheet_title == 'undefined' || worksheet_title == null) {
                        worksheet_title = 0;
                    }

                    /** Ajax call to fetch all worksheets of spreadsheet  */
                    $.ajax({
                        url: '<?php echo admin_url( 'admin-ajax.php' ); ?>',
                        type: "POST",
                        data: {
                            'action': 'wfco_gs_get_worksheets',
                            'id': spreadsheet_id,
                            '_wpnonce': bwfanParams.ajax_nonce
                        },
                        success: function (result) {
                            $this.removeClass('wfco_loading');
                            $('.wp_spinner_gif').remove();

                            if (0 == result.success) {
                                error_generated = $this.parent().parent().parent().find('div.error.wfco_error').html();
                                if ('undefined' == typeof error_generated) {
                                    $this.parent().parent().after("<div class='error wfco_error'></div>");
                                }

                                $('.error.wfco_error').fadeIn().html(result.result);
                                setTimeout(function () {
                                    $('.error.wfco_error').fadeOut("slow");
                                }, 2500);

                                return;
                            }

                            var worksheets = {};
                            var worksheets_column = {};
                            if ('worksheets' in result.result) {
                                $.each(result.result.worksheets, function (key, value) {
                                    worksheets[value] = value;
                                });
                            } else {
                                $.each(result.result, function (key, value) {
                                    worksheets[value] = value;
                                });
                            }

                            if ('sheets_column' in result.result) {
                                $.each(result.result.sheets_column, function (key, value) {
                                    worksheets_column[key] = value;
                                });
                            }

                            var data_values = {worksheet_title: worksheet_title, spreadsheet_id: spreadsheet_id};
                            var default_sheet_column = bwfan_set_actions_js_data['<?php echo $this->get_class_slug(); ?>']['worksheet_column_options']
                            if (_.size(Object.values(worksheets_column)[0]) > 26) {
                                default_sheet_column = Object.values(worksheets_column)[0]
                            }
                            var actionFieldsOptions = {
                                worksheet_column_options: default_sheet_column
                            };
                            bwfan_set_actions_js_data['<?php echo $this->get_class_slug(); ?>']['worksheet_column_options'] = default_sheet_column;
                            var data_options = {worksheet_title_options: worksheets, worksheet_title_column: worksheets_column};
                            BWFAN_Actions.recreate_action_ui_ajax($('#bwfan-actions-form'), data_values, data_options);
                        }
                    });
                });

                /** change the column details on sheet change **/
                $('body').on('change', '#wfco_delete_select_worksheet', function (event) {
                    var worksheet_title = $(this).val();
                    var action_id = $(".bwfan-selected-action").attr('data-group-id');
                    var ajax_values = JSON.parse($("input[name='bwfan[" + action_id + "][ajax-data]'").val());
                    var default_option = bwfan_set_actions_js_data['<?php echo $this->get_class_slug(); ?>']['worksheet_column_options'];
                    var worksheet_title_column = ('worksheet_title_column' in ajax_values) ? ajax_values.worksheet_title_column : default_option;
                    if (worksheet_title_column.hasOwnProperty(worksheet_title)) {
                        if (_.size(worksheet_title_column[worksheet_title]) > 26) {
                            worksheet_title_column = worksheet_title_column[worksheet_title];
                        } else {
                            worksheet_title_column = default_option;
                        }
                    }

                    var actionFieldsOptions = {
                        worksheet_column_options: worksheet_title_column,
                    };
                    bwfan_set_actions_js_data['<?php echo $this->get_class_slug(); ?>']['worksheet_column_options'] = worksheet_title_column;

                    $(".gs-delete-search-fields").each(function () {
                        var i = 0;
                        var selected_option = $(this).find('.gs-delete-column-option').val();
                        var new_option = update_option_html(worksheet_title_column, selected_option);
                        $(this).find('.gs-delete-column-option').html(new_option);
                    });
                });

                function update_option_html(worksheet_column_option, selected_option) {
                    var html = '<option>Column</option>';
                    $.each(worksheet_column_option, function (key, value) {
                        selected = key === selected_option ? 'selected' : '';
                        html += '<option value="' + key + '" ' + selected + '>' + value + '</option>';
                    });
                    return html;
                }
            });
        </script>
		<?php
	}

	public function make_data( $integration_object, $task_meta ) {
		$this->add_action();
		$data_to_set                                   = array();
		$data_to_set['spreadsheet_id']                 = $task_meta['data']['spreadsheet_id'];
		$data_to_set['worksheet_title']                = $task_meta['data']['worksheet_title'];
		$data_to_set['worksheet_search_data']['key']   = $task_meta['data']['worksheet_search_data']['column'][0];
		$data_to_set['worksheet_search_data']['value'] = BWFAN_Common::decode_merge_tags( $task_meta['data']['worksheet_search_data']['value'][0] );
		$this->remove_action();

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$this->add_action();
		$data_to_set                                   = array();
		$data_to_set['spreadsheet_id']                 = $step_data['spreadsheet_data']['spreadsheet_id'];
		$data_to_set['worksheet_title']                = $step_data['spreadsheet_data']['worksheet_title'];
		$data_to_set['worksheet_search_data']['key']   = $step_data['spreadsheet_data']['worksheet_search_data']['col'];
		$data_to_set['worksheet_search_data']['value'] = BWFAN_Common::decode_merge_tags( $step_data['spreadsheet_data']['worksheet_search_data']['value'] );
		$this->remove_action();

		return $data_to_set;
	}

	private function add_action() {
		add_filter( 'bwfan_order_billing_address_separator', [ $this, 'change_br_to_slash_n' ] );
		add_filter( 'bwfan_order_shipping_address_separator', [ $this, 'change_br_to_slash_n' ] );
	}

	private function remove_action() {
		remove_filter( 'bwfan_order_billing_address_params', [ $this, 'change_br_to_slash_n' ] );
		remove_filter( 'bwfan_order_shipping_address_separator', [ $this, 'change_br_to_slash_n' ] );
	}

	public function execute_action( $action_data ) {
		$load_connector = WFCO_Load_Connectors::get_instance();
		$call           = $load_connector->get_call( 'wfco_gs_delete_data' );
		if ( is_null( $call ) ) {
			return array(
				'status'  => 4,
				'message' => __( 'No delete call found', 'autonami-automations-connectors' ),
			);
		}

		$call->set_data( $action_data['processed_data'] );
		$result = $call->process();
		if ( false === $result ) {
			return array(
				'status'  => 4,
				'message' => __( 'No client call found', 'autonami-automations-connectors' ),
			);
		}

		if ( true === $result ) {
			return array(
				'status'  => 3,
				'message' => __( 'Data successfully deleted in the google spreadsheet.', 'autonami-automations-connectors' ),
			);
		}

		$codes = BWFAN_Google_Sheets_Integration::get_permanent_failure_error_codes();
		if ( in_array( $result[0], $codes ) ) {
			if ( 403 == $result[0] && strpos( $result[1], 'Limit' ) !== false ) {
				return array(
					'status'  => 0,
					'message' => $result[1],
				);
			}

			return array(
				'status'  => 4,
				'message' => $result[1],
			);
		}

		return array(
			'status'  => 0,
			'message' => $result[1],
		);
	}

	public function handle_response_v2( $result ) {
		if ( false === $result ) {
			return $this->error_response( __( 'No client call found', 'autonami-automations-connectors' ) );
		}

		if ( true === $result ) {
			return $this->success_message( __( 'Data successfully updated in the google spreadsheet.', 'autonami-automations-connectors' ) );
		}

		$codes = BWFAN_Google_Sheets_Integration::get_permanent_failure_error_codes();
		if ( in_array( $result[0], $codes ) ) {
			if ( 403 == $result[0] && strpos( $result[1], 'Limit' ) !== false ) {
				return $this->success_message( $result[1] );
			}

			return $this->error_response( $result[1] );
		}

		return $this->success_message( $result[1] );
	}

	public function change_br_to_slash_n() {
		return "\n";
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		return [
			[
				'id'          => 'spreadsheet_data',
				'label'       => __( 'Enter Google SpreadSheet ID', 'autonami-automations-connectors' ),
				'type'        => 'google_sheet',
				'operation'   => 'delete',
				'class'       => 'bwfan-col-sm-9',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
			]
		];
	}
}

return 'BWFAN_GS_Delete_Data';
