<?php

namespace WFCO\GoogleSheet;

#[\AllowDynamicProperties]
class Delete_Data extends \WFCO_Call {

	private static $instance = null;

	public function __construct() {

		$this->required_fields = array( 'spreadsheet_id', 'worksheet_title', 'worksheet_search_data' );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gs_delete_data';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$client = \BWFCO_Google_Sheets::get_google_client();
		if ( is_null( $client ) ) {
			return false;
		}

		$service = new \Google_Service_BWFSheets( $client );
		$range   = $this->data['worksheet_title'] . '!' . $this->data['worksheet_search_data']['key'] . '1:' . $this->data['worksheet_search_data']['key'];
		try {
			$response = $service->spreadsheets_values->get( $this->data['spreadsheet_id'], $range );
		} catch ( \Exception $exception ) {
			$errors = $exception->getErrors();

			return array(
				0 => $exception->getCode(),
				1 => $errors[0]['message'],
			);
		}

		$get_values = $response->getValues();

		/* getting worksheet gid using worksheet title */
		$worksheets = \BWFCO_Google_Sheets::get_google_worksheets( $this->data['spreadsheet_id'] );
		$sheetID    = 0;
		$worksheets = isset( $worksheets['worksheets'] ) ? $worksheets['worksheets'] : $worksheets;
		if ( ! empty( $worksheets ) ) {
			foreach ( $worksheets as $worksheet_id => $worksheet_title ) {
				if ( $worksheet_title == $this->data['worksheet_title'] ) {
					$sheetID = $worksheet_id;
				}
			}
		}

		foreach ( $get_values as $key => $data ) {
			if ( in_array( $this->data['worksheet_search_data']['value'], $data, true ) ) {
				$row             = $key;
				$deleteOperation = array(
					'range' => array(
						'sheetId'    => absint( $sheetID ), // <======= This mean the very first sheet on worksheet
						'dimension'  => 'ROWS',
						'startIndex' => $row, //Identify the starting point,
						'endIndex'   => ( $row + 1 ) //Identify where to stop when deleting
					)
				);

				$deletable_row[] = new \Google_Service_Sheets_BWFRequest( array( 'deleteDimension' => $deleteOperation ) );
				$delete_body     = new \Google_Service_Sheets_BWFBatchUpdateSpreadsheetRequest( array(
					'requests' => $deletable_row
				) );
				try {
					$service->spreadsheets->batchUpdate( $this->data['spreadsheet_id'], $delete_body );
				} catch ( \Exception $exception ) {
					$errors = $exception->getErrors();

					return array(
						0 => $exception->getCode(),
						1 => $errors[0]['message'],
					);
				}

			}
		}

		return true;
	}

	public function get_all_columns() {
		return array(
			'A' => 'A',
			'B' => 'B',
			'C' => 'C',
			'D' => 'D',
			'E' => 'E',
			'F' => 'F',
			'G' => 'G',
			'H' => 'H',
			'I' => 'I',
			'J' => 'J',
			'K' => 'K',
			'L' => 'L',
			'M' => 'M',
			'N' => 'N',
			'O' => 'O',
			'P' => 'P',
			'Q' => 'Q',
			'R' => 'R',
			'S' => 'S',
			'T' => 'T',
			'U' => 'U',
			'V' => 'V',
			'W' => 'W',
			'X' => 'X',
			'Y' => 'Y',
			'Z' => 'Z',
		);
	}


}

return 'WFCO\GoogleSheet\Delete_Data';