<?php

#[AllowDynamicProperties]
final class BWFAN_Hubspot_Remove_Contact_From_Workflow extends BWFAN_Action {

	private static $ins = null;
	private $not_supprted = false;

	private function __construct() {
		$this->action_name     = __( 'Remove Contact from Workflow', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action for remove Contact from Hubspot Workflow', 'autonami-automations-connectors' );
		$this->action_priority = 70;
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'workflows', $data );
		}
	}

	public function get_view_data() {
		$workflows = WFCO_Common::get_single_connector_data( $this->connector, 'workflows' );
		if ( ! empty( $workflows ) && ! is_array( $workflows ) ) {
			$this->not_supprted = true;
		}

		return $workflows;
	}

	/**
	 * Show the html fields for the current action.
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		if ( true === $this->not_supprted ) {
			?>
            <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
                <#
                jQuery('.bwfan-input-form .bwfan-timer-fields,.bwfan-input-form .bwfan-priority-fields,.bwfan-row-sep').remove();
                #>
                <p><?php esc_html_e( 'Workflow is not supported.', 'autonami-automations-connectors' ); ?></p>
            </script>
			<?php

			return;
		} ?>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            selected_workflow = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'workflow_id')) ? data.actionSavedData.data.workflow_id : '';
            body = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'body')) ? data.actionSavedData.data.body : '';
            entered_email = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'email')) ? data.actionSavedData.data.email : '';
            #>
            <label for="" class="bwfan-label-title">
				<?php
				echo esc_html__( 'Select Workflow', 'autonami-automations-connectors' );
				$message = __( 'Select a Workflow and if unable to locate then sync the connector.', 'autonami-automations-connectors' );
				echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
				?>
            </label>
            <select required id="" class="bwfan-single-select bwfan-input-wrapper" name="bwfan[{{data.action_id}}][data][workflow_id]">
                <option value=""><?php echo esc_html__( 'Choose a Audience', 'autonami-automations-connectors' ); ?></option>
                <#
                if(_.has(data.actionFieldsOptions, 'workflows') && _.isObject(data.actionFieldsOptions.workflows) ) {
                _.each( data.actionFieldsOptions.workflows, function( value, key ){
                selected = (key == selected_workflow) ? 'selected' : '';
                #>
                <option value="{{key}}" {{selected}}>{{value}}</option>
                <# })
                }
                #>
            </select>

        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set                = array();
		$data_to_set['api_key']     = $integration_object->get_settings( 'api_key' );
		$data_to_set['workflow_id'] = $task_meta['data']['workflow_id'];

		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set                = array();
		$data_to_set['api_key']     = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['workflow_id'] = $step_data['workflow_id'];
		$data_to_set['email']       = $automation_data['global']['email'];

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	public function before_executing_task() {
		add_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10, 1 );
	}

	public function after_executing_task() {
		remove_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10 );
	}

	public function return_confirmation( $bool ) {
		if ( $this->is_action_tag ) {
			$bool = true;
		}

		return $bool;
	}

	protected function handle_response( $result, $call_object = null ) {
		return $result;
	}

	public function handle_response_v2( $result ) {
		if ( ! isset( $result['status'] ) ) {
			return $this->error_response( __( 'Unknown API Exception', 'autonami-automations-connectors' ) );
		}

		$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
		if ( 4 === absint( $result['status'] ) ) {
			return $this->error_response( $message );
		}

		return $this->success_message( $message );

	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$workflows = $this->get_view_data();
		$workflows = is_array( $workflows ) ? $workflows : [];
		$workflows = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $workflows ) );

		return [
			[
				'id'          => 'workflow_id',
				'label'       => __( "Select Workflow", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $workflows,
				'placeholder' => "Choose A workflow",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['workflow_id'] ) || empty( $data['workflow_id'] ) ) {
			return '';
		}

		$workflows = $this->get_view_data();
		if ( ! isset( $workflows[ $data['workflow_id'] ] ) || empty( $workflows[ $data['workflow_id'] ] ) ) {
			return '';
		}

		return $workflows[ $data['workflow_id'] ];
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Hubspot_Remove_Contact_From_Workflow';
