<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Create_Contact extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'email' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_create_contact';
	}

	public function process_hubspot_call() {
		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$params = [
			"properties"       => [
				"email"     => $this->data['email'],
				"firstname" => isset( $this->data['firstname'] ) ? $this->data['firstname'] : '',
				"lastname"  => isset( $this->data['lastname'] ) ? $this->data['lastname'] : '',
			],
			'bwfan_con_source' => 'autonami',
		];

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/contacts';
	}

}

return 'WFCO\HubSpot\Create_Contact';
