<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Get_Contact_By_Email extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'email' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_get_contact_by_email';
	}

	public function process_hubspot_call() {
		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$param = [
			"filterGroups"     => [
				[
					"filters" => [
						[
							"propertyName" => "email",
							"operator"     => "EQ",
							"value"        => $this->data['email']
						]
					]
				]
			],
			"sorts"            => [
				"vid"
			],
			"query"            => $this->data['email'],
			"properties"       => [
				"vid"
			],
			"limit"            => 1,
			"after"            => 0,
			'bwfan_con_source' => 'autonami',
		];

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $param ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/contacts/search';
	}

}

return 'WFCO\HubSpot\Get_Contact_By_Email';
