<?php

#[AllowDynamicProperties]
final class BWFAN_Klaviyo_Add_To_List extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Add to List', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action adds a contact to the selected list', 'autonami-automations-connectors' );
		$this->action_priority = 10;
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'lists', $data );
		}
	}

	public function get_view_data() {
		return WFCO_Common::get_single_connector_data( $this->connector, 'lists' );
	}

	/**
	 * Show the html fields for the current action.
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            selected_list = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'list_id')) ? data.actionSavedData.data.list_id : '';
            body = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'body')) ? data.actionSavedData.data.body : '';
            entered_email = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'email')) ? data.actionSavedData.data.email : '';
            sms_consent = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'sms_consent')) ? data.actionSavedData.data.sms_consent : [];
            #>
            <label for="" class="bwfan-label-title">
				<?php
				echo esc_html__( 'Select List', 'autonami-automations-connectors' );
				$message = __( 'Select a List and if unable to locate then sync the connector.', 'autonami-automations-connectors' );
				echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
				?>
            </label>
            <select required id="" class="bwfan-single-select bwfan-input-wrapper" name="bwfan[{{data.action_id}}][data][list_id]">
                <option value=""><?php echo esc_html__( 'Choose a Audience', 'autonami-automations-connectors' ); ?></option>
                <#
                if(_.has(data.actionFieldsOptions, 'lists') && _.isObject(data.actionFieldsOptions.lists) ) {
                _.each( data.actionFieldsOptions.lists, function( value, key ){
                selected = (key == selected_list) ? 'selected' : '';
                #>
                <option value="{{key}}" {{selected}}>{{value}}</option>
                <# })
                }
                #>
            </select>
            <#
            is_sms_consent = _.contains(sms_consent,"sms")?"checked":"";
            #>
            <div class="bwfan-col-sm-12 bwfan-p-0 bwfan-mt-15">
                <label class="bwfan-label-title"><?php esc_html_e( 'Consent', 'autonami-automations-connectors' ) ?></label>
                <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                    <input type="checkbox" name="bwfan[{{data.action_id}}][data][sms_consent][]" id="bwfan_end_automation" value="sms" {{is_sms_consent}}/>
                    <label for="bwfan_end_automation" class="bwfan-checkbox-label"><?php esc_html_e( 'SMS' ) ?></label>
                </div>
            </div>
        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set                = array();
		$data_to_set['api_key']     = $integration_object->get_settings( 'api_key' );
		$data_to_set['list_id']     = $task_meta['data']['list_id'];
		$data_to_set['sms_consent'] = $task_meta['data']['sms_consent'];

		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		if ( ! empty( $data_to_set['sms_consent'] ) && ! empty( $data_to_set['email'] ) ) {
			$contact              = new BWFCRM_Contact( $data_to_set['email'] );
			$data_to_set['phone'] = $contact->is_contact_exists() ? $contact->contact->get_contact_no() : '';
		}

		/** set country code in case of order and  cart abandoned event */
		if ( isset( $task_meta['global'] ) && isset( $task_meta['global']['order_id'] ) ) {
			$data_to_set['order_id'] = $task_meta['global']['order_id'];
		} elseif ( isset( $task_meta['global'] ) && isset( $task_meta['global']['cart_abandoned_id'] ) ) {
			$data_to_set['cart_abandoned_id'] = $task_meta['global']['cart_abandoned_id'];
		}

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set                  = array();
		$data_to_set['api_key']       = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['list_id']       = $step_data['list_id'];
		$data_to_set['sms_consent']   = isset( $step_data['sms_consent'] ) ? $step_data['sms_consent'] : 0;
		$data_to_set['email_consent'] = isset( $step_data['email_consent'] ) ? $step_data['email_consent'] : 0;
		$data_to_set['email']         = isset( $automation_data['global']['email'] ) ? $automation_data['global']['email'] : '';

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		/** Set phone number if not set */
		if ( ! empty( $data_to_set['sms_consent'] ) && ! empty( $data_to_set['email'] ) ) {
			$contact              = new BWFCRM_Contact( $data_to_set['email'] );
			$data_to_set['phone'] = $contact->is_contact_exists() ? $contact->contact->get_contact_no() : '';
		}

		/** set country code in case of order and  cart abandoned event */
		if ( isset( $automation_data['global'] ) && isset( $automation_data['global']['order_id'] ) ) {
			$data_to_set['order_id'] = $automation_data['global']['order_id'];
		} elseif ( isset( $automation_data['global'] ) && isset( $automation_data['global']['cart_abandoned_id'] ) ) {
			$data_to_set['cart_abandoned_id'] = $automation_data['global']['cart_abandoned_id'];
		}

		return $data_to_set;
	}

	public function before_executing_task() {
		add_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10, 1 );
	}

	public function after_executing_task() {
		remove_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10 );
	}

	public function return_confirmation( $bool ) {
		if ( $this->is_action_tag ) {
			$bool = true;
		}

		return $bool;
	}

	protected function handle_response( $result, $call_object = null ) {
		return $result;
	}

	public function handle_response_v2( $result ) {
		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		/** If success (within 200 status), then return payload (actual response) and status, message */
		if ( ( absint( $result['response'] ) - 200 ) < 100 ) {
			return $this->success_message( __( 'Klaviyo API call executed successfully', 'autonami-automations-connectors' ) );
		}

		$klaviyo_error = "";
		$unknown_error = "";
		/** If failed, send appropriate error */
		$response_code = __( '. Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		if ( isset( $result['body']['message'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['message'] . ', Code: ' . $result['response'];
		}
		if ( isset( $result['body']['detail'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['detail'] . ', Code: ' . $result['response'];
		}

		if ( empty( $klaviyo_error ) ) {
			$unknown_error = __( 'Unknown Klaviyo Error', 'autonami-automations-connectors' ) . $response_code;
		}

		return $this->error_response( ( false !== $klaviyo_error ? $klaviyo_error : $unknown_error ) );
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$lists = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $this->get_view_data() ) );

		return [
			[
				'id'          => 'list_id',
				'label'       => __( "Select List", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $lists,
				'placeholder' => "Select",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"hint"        => __( "Klaviyo list has an <b>Opt-in process</b> setting. If <b>Single opt-in</b> then the list will be assigned directly and if <b>Double opt-in</b>, the user needs to verify from email.", 'autonami-automations-connectors' ),
				"required"    => true,
			],
			[
				'id'            => 'email_consent',
				'checkboxlabel' => __( "Email Consent", 'autonami-automations-connectors' ),
				'type'          => 'checkbox',
				"class"         => 'bwfan-input-wrapper',
				'tip'           => __( '', 'autonami-automations-connectors' ),
				"description"   => '',
				"required"      => false,
			],
			[
				'id'            => 'sms_consent',
				'checkboxlabel' => __( "SMS Consent", 'autonami-automations-connectors' ),
				'type'          => 'checkbox',
				"class"         => 'bwfan-input-wrapper',
				'tip'           => __( '', 'autonami-automations-connectors' ),
				"description"   => '',
				"required"      => false,
			],

		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['list_id'] ) || empty( $data['list_id'] ) ) {
			return '';
		}

		$lists = $this->get_view_data();
		if ( ! isset( $lists[ $data['list_id'] ] ) || empty( $lists[ $data['list_id'] ] ) ) {
			return '';
		}

		return $lists[ $data['list_id'] ];
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Klaviyo_Add_To_List';
