<?php

#[AllowDynamicProperties]
final class BWFAN_Klaviyo_Remove_From_List extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Remove from List', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action removes a contact from the selected list', 'autonami-automations-connectors' );
		$this->action_priority = 20;
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'lists', $data );
		}
	}

	public function get_view_data() {
		$lists = WFCO_Common::get_single_connector_data( $this->connector, 'lists' );

		return $lists;
	}

	/**
	 * Show the html fields for the current action.
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            selected_list = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'list_id')) ? data.actionSavedData.data.list_id : '';
            body = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'body')) ? data.actionSavedData.data.body : '';
            entered_email = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'email')) ? data.actionSavedData.data.email : '';
            #>
            <label for="" class="bwfan-label-title">
				<?php
				echo esc_html__( 'Select List', 'autonami-automations-connectors' );
				$message = __( 'Select a List and if unable to locate then sync the connector.', 'autonami-automations-connectors' );
				echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
				?>
            </label>
            <select required id="" class="bwfan-single-select bwfan-input-wrapper" name="bwfan[{{data.action_id}}][data][list_id]">
                <option value=""><?php echo esc_html__( 'Choose a Audience', 'autonami-automations-connectors' ); ?></option>
                <#
                if(_.has(data.actionFieldsOptions, 'lists') && _.isObject(data.actionFieldsOptions.lists) ) {
                _.each( data.actionFieldsOptions.lists, function( value, key ){
                selected = (key == selected_list) ? 'selected' : '';
                #>
                <option value="{{key}}" {{selected}}>{{value}}</option>
                <# })
                }
                #>
            </select>

        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set            = array();
		$data_to_set['api_key'] = $integration_object->get_settings( 'api_key' );
		$data_to_set['list_id'] = $task_meta['data']['list_id'];

		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set            = array();
		$data_to_set['api_key'] = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['list_id'] = $step_data['list_id'];

		$data_to_set['email'] = $automation_data['global']['email'];

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	public function before_executing_task() {
		add_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10, 1 );
	}

	public function after_executing_task() {
		remove_filter( 'bwfan_current_integration_action', [ $this, 'return_confirmation' ], 10 );
	}

	public function return_confirmation( $bool ) {
		if ( $this->is_action_tag ) {
			$bool = true;
		}

		return $bool;
	}

	protected function handle_response( $result, $call_object = null ) {
		return $result;
	}

	public function handle_response_v2( $result ) {

		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		/** If success (within 200 status), then return payload (actual response) and status, message */
		if ( ( absint( $result['response'] ) - 200 ) < 100 ) {
			return $this->success_message( __( 'Klaviyo API call executed successfully', 'autonami-automations-connectors' ) );
		}

		$klaviyo_error = "";
		$unknown_error = "";
		/** If failed, send appropriate error */
		$response_code = __( '. Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		if ( isset( $result['body']['message'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['message'] . ', Code: ' . $result['response'];
		}
		if ( isset( $result['body']['detail'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['detail'] . ', Code: ' . $result['response'];
		}

		if ( empty( $klaviyo_error ) ) {
			$unknown_error = __( 'Unknown Klaviyo Error', 'autonami-automations-connectors' ) . $response_code;
		}

		return $this->error_response( ( false !== $klaviyo_error ? $klaviyo_error : $unknown_error ) );
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$lists = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $this->get_view_data() ) );

		return [
			[
				'id'          => 'list_id',
				'label'       => __( "Select List", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $lists,
				'placeholder' => "Select",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( 'Select a List and if unable to locate then sync the connector.', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['list_id'] ) || empty( $data['list_id'] ) ) {
			return '';
		}

		$lists = $this->get_view_data();
		if ( ! isset( $lists[ $data['list_id'] ] ) || empty( $lists[ $data['list_id'] ] ) ) {
			return '';
		}

		return $lists[ $data['list_id'] ];
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Klaviyo_Remove_From_List';
