<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Add_To_List extends WFCO_Klaviyo_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'list_id', 'email' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_add_to_list';
	}

	public function process_klaviyo_call() {
		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}
		$connectors = \WFCO_Load_Connectors::get_instance();
		$call       = $connectors->get_call( 'wfco_klaviyo_get_profile' );
		$call->set_data( $this->data );
		$result = $call->process();

		$profile_id = isset( $result['payload']['data'][0]['id'] ) ? $result['payload']['data'][0]['id'] : 0;

		if ( empty( $profile_id ) ) {
			/** Create Profile */
			$call = $connectors->get_call( 'wfco_klaviyo_add_profile' );
			$call->set_data( $this->data );
			$result = $call->process();
			if ( isset( $result['status'] ) && 4 === $result['status'] ) {
				return $this->get_autonami_error( $result['message'] );
			}
			$profile_id = isset( $result['payload']['data']['id'] ) ? $result['payload']['data']['id'] : 0;
		}

		if ( ! empty( $this->data['email_consent'] ) || ! empty( $this->data['sms_consent'] ) ) {
			/** This call is also add profile in list */
			$profile_status_call   = $connectors->get_call( 'wfco_klaviyo_change_profile_status' );
			$this->data['profile'] = $profile_id;
			$profile_status_call->set_data( $this->data );

			return $profile_status_call->process();
		}

		$user_data = array(
			'type' => 'profile',
			'id'   => $profile_id
		);
		$profiles  = array( array_filter( $user_data ) );
		$params    = array(
			'data'             => $profiles,
			'bwfan_con_source' => 'autonami'
		);

		return $this->do_klaviyo_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}


	/** get country code for passing sms consent in klaviyo */
	public function get_country_code( $data ) {
		$country_code = '';
		if ( ! empty( $data['order_id'] ) ) {
			$order_details = wc_get_order( $data['order_id'] );

			/** Appending country code */
			$country = $order_details->get_billing_country();
			if ( ! empty( $country ) ) {
				$country_code = $country;
			}
		} else if ( ! empty( $data['cart_abandoned_id'] ) ) {
			/** Cart abandonment case */
			$cart_details = \BWFAN_Merge_Tag_Loader::get_data( 'cart_details' );

			/** Appending country code in case available */
			$checkout_data = json_decode( $cart_details['checkout_data'], true );
			if ( is_array( $checkout_data ) && isset( $checkout_data['fields'] ) && isset( $checkout_data['fields']['billing_country'] ) && ! empty( $checkout_data['fields']['billing_country'] ) ) {
				$country_code = $checkout_data['fields']['billing_country'];
			}
		}

		return $country_code;
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {

		return \BWFCO_Klaviyo::$api_end_point . 'lists/' . $this->data['list_id'] . '/relationships/profiles/';

	}

}

return 'WFCO\Klaviyo\Add_To_List';
