<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Change_Profile_Status extends WFCO_Klaviyo_Call {

	private static $ins = null;
	private $api_params = [];
	private $action = null;

	public function __construct() {
		parent::__construct( [ 'api_key', 'list_id' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_change_profile_status';
	}

	public function process_klaviyo_call() {
		if ( empty( $this->data['phone'] ) ) {
			$this->data['phone'] = isset( $this->data['profile_fields']['phone_number'] ) ? $this->data['profile_fields']['phone_number'] : '';
		}
		$params       = $this->get_subscribed_data();
		$this->action = isset( $this->data['action'] ) ? $this->data['action'] : '';
		if ( 'unsubscribe' === $this->action ) {
			$params = $this->get_unsubscribed_data();
		}

		/** If sms consent is disabled then unset the phone number */
		if ( 'unsubscribe' !== $this->action && empty( $this->data['sms_consent'] ) ) {
			unset( $params['data']['attributes']['profiles']['data'][0]['attributes']['phone_number'] );
			if ( isset( $params['data']['attributes']['profiles']['data'][0]['attributes']['subscriptions']['sms'] ) ) {
				unset( $params['data']['attributes']['profiles']['data'][0]['attributes']['subscriptions']['sms'] );
			}
		}

		/** If email consent is disabled then unset the email */
		if ( 'unsubscribe' !== $this->action && empty( $this->data['email_consent'] ) ) {
			unset( $params['data']['attributes']['profiles']['data'][0]['attributes']['email'] );
			if ( isset( $params['data']['attributes']['profiles']['data'][0]['attributes']['subscriptions']['email'] ) ) {
				unset( $params['data']['attributes']['profiles']['data'][0]['attributes']['subscriptions']['email'] );
			}
		}

		/** If email consent is enabled or email is empty then unset the email from parameters */
		if ( ( 'unsubscribe' === $this->action && ! empty( $this->data['email_consent'] ) ) || empty( $params['data']['attributes']['profiles']['data'][0]['attributes']['email'] ) ) {
			unset( $params['data']['attributes']['profiles']['data'][0]['attributes']['email'] );
		}

		/** If sms consent is enabled or phone number is empty then unset the phone number from parameters */
		if ( ( 'unsubscribe' === $this->action && ! empty( $this->data['sms_consent'] ) ) || empty( $params['data']['attributes']['profiles']['data'][0]['attributes']['phone_number'] ) ) {
			unset( $params['data']['attributes']['profiles']['data'][0]['attributes']['phone_number'] );
		}

		if ( isset( $params['data']['attributes']['profiles']['data'][0]['id'] ) && empty( $params['data']['attributes']['profiles']['data'][0]['id'] ) ) {
			unset( $params['data']['attributes']['profiles']['data'][0]['id'] );
		}

		return $this->do_klaviyo_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}

	/**
	 * Get subscribe data
	 *
	 * @return array[]
	 */
	private function get_subscribed_data() {
		return [
			"data" => [
				"type"          => "profile-subscription-bulk-create-job",
				"attributes"    => [
					"custom_source" => "Marketing Event",
					"profiles"      => [
						"data" => [
							[
								"type"       => "profile",
								"id"         => isset( $this->data['profile'] ) ? $this->data['profile'] : '',
								"attributes" => [
									"email"         => $this->data['email'],
									"phone_number"  => $this->data['phone'],
									"subscriptions" => [
										"email" => [
											"MARKETING"
										],
										"sms"   => [
											"MARKETING"
										],
									]
								]
							]
						]
					]
				],
				"relationships" => [
					"list" => [
						"data" => [
							"type" => "list",
							"id"   => $this->data['list_id']
						]
					]
				]
			]
		];
	}

	/**
	 * Get unsubscribe data
	 *
	 * @return array[]
	 */
	private function get_unsubscribed_data() {
		return [
			"data" => [
				"type"          => "profile-subscription-bulk-delete-job",
				"attributes"    => [
					"profiles" => [
						"data" => [
							[
								"type"       => "profile",
								"attributes" => [
									"email"        => $this->data['email'],
									"phone_number" => $this->data['phone'],
								]
							]
						]
					]
				],
				"relationships" => [
					"list" => [
						"data" => [
							"type" => "list",
							"id"   => $this->data['list_id']
						]
					]
				]
			]
		];
	}


	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		$url_endpoint = 'profile-subscription-bulk-create-jobs/';
		if ( 'unsubscribe' === $this->action ) {
			$url_endpoint = 'profile-subscription-bulk-delete-jobs/';
		}
		$url = \BWFCO_Klaviyo::$api_end_point . $url_endpoint;

		return add_query_arg( $this->api_params, $url );
	}

}

return 'WFCO\Klaviyo\Change_Profile_Status';
