<?php

namespace WFCO\MailerLite;

#[\AllowDynamicProperties]
class Add_Group extends WFCO_Mailerlite_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'name' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_mailerlite_add_group';
	}

	public function process_mailerlite_call() {
		$params = [ 'name' => $this->data['name'], 'bwfan_con_source' => 'autonami' ];

		return $this->do_mailerlite_call( $params, \BWF_CO::$POST );
	}

	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Mailerlite::$api_end_point . 'groups';
	}

}

return 'WFCO\MailerLite\Add_Group';
