<?php

namespace WFCO\Mautic;

#[\AllowDynamicProperties]
class Get_Segments extends WFCO_Mautic_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'site_url', 'access_token' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_mautic_get_segments';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}
		$params          = array();
		$params['start'] = isset( $this->data['start'] ) ? $params['start'] = absint( $this->data['start'] ) : null;
		$params['limit'] = isset( $this->data['limit'] ) ? $params['limit'] = absint( $this->data['limit'] ) : null;

		\BWFCO_Mautic::set_headers();

		return $this->make_wp_requests( $this->get_endpoint(), $params, \BWFCO_Mautic::get_headers(), \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {

		return rtrim( $this->data['site_url'], '/' ) . '/api/segments?access_token=' . $this->data['access_token'];
	}

}

return 'WFCO\Mautic\Get_Segments';
