<?php

namespace WFCO\Ontraport;

#[\AllowDynamicProperties]
class Get_Campaign extends \WFCO_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'app_id', 'api_key' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_ontraport_get_campaign';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}
		\BWFCO_Ontraport::set_headers( $this->data );

		return $this->make_wp_requests( $this->get_endpoint(), array(), \BWFCO_Ontraport::get_headers(), \BWF_CO::$GET );
	}


	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		return \BWFCO_Ontraport::get_endpoint() . '/CampaignBuilderItems';
	}

}

return 'WFCO\Ontraport\Get_Campaign';
