<?php

namespace WFCO\EverWebinar;

#[\AllowDynamicProperties]
class Get_Webinars extends \WFCO_Call {
	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'api_key' );
		$this->api_end_point   = 'https://api.webinarjam.com/everwebinar/webinars';
	}

	/**
	 * @return Get_Webinars|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_everwebinar_get_webinars';
	}

	/**
	 * Process and do the actual processing for the current action.
	 * This function is present in every action class.
	 */
	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params            = [];
		$params['api_key'] = $this->data['api_key'];

		$res = $this->make_wp_requests( $this->api_end_point, $params, array(), \BWF_CO::$POST );

		/**
		 * res will contain success message if api_key is correct along with the list of webinars
		 */
		return $res;
	}

}

return 'WFCO\EverWebinar\Get_Webinars';
