<?php

namespace WFCO\WebinarJam;

#[\AllowDynamicProperties]
class Register_Person_To_Webinar extends \WFCO_Call {

	private static $ins = null;
	public $endpoint = null;

	public function __construct() {

		$this->required_fields = array( 'api_key', 'first_name', 'email', 'webinar_id', 'schedule' );
		$this->endpoint        = 'https://api.webinarjam.com/webinarjam/register';
	}

	/**
	 * @return Register_Person_To_Webinar|null
	 */
	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_webinarjam_register_person_to_webinar';
	}

	/**
	 * Process and do the actual processing for the current action.
	 * This function is present in every action class.
	 */
	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'api_key'    => $this->data['api_key'],
			'webinar_id' => $this->data['webinar_id'],
			'first_name' => $this->data['first_name'],
			'email'      => $this->data['email'],
			'schedule'   => $this->data['schedule'],
		);

		if ( ! empty( $this->data['last_name'] ) ) {
			$params['last_name'] = $this->data['last_name'];
		}

		if ( ! empty( $this->data['phone'] ) ) {
			$params['phone'] = $this->data['phone'];
		}


		$res = $this->make_wp_requests( $this->endpoint, $params, array(), \BWF_CO::$POST );

		return $res;
	}

}

return 'WFCO\WebinarJam\Register_Person_To_Webinar';
