<?php

namespace WFCO\GetResponse;

#[\AllowDynamicProperties]
class Search_Contacts_By_Email extends \WFCO_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'api_key', 'email' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gr_search_contacts_by_email';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		if ( ! is_email( $this->data['email'] ) ) {
			return array(
				'response' => 502,
				'body'     => array( 'Email is not valid' ),
			);
		}

		\BWFCO_GetResponse::set_headers( $this->data['api_key'] );
		$params = array( 'bwfan_con_source' => 'autonami' );

		return $this->make_wp_requests( $this->get_endpoint(), $params, \BWFCO_GetResponse::get_headers(), \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		return \BWFCO_GetResponse::get_endpoint() . 'contacts?query[email]=' . $this->data['email'];
	}

}

return 'WFCO\GetResponse\Search_Contacts_By_Email';
