<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Create_Deal extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( [ 'api_key', 'order_id', 'email' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_create_deal';
	}

	public function process_hubspot_call() {

		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$contact_id = $this->get_contact_by_email();

		if ( empty( $contact_id ) ) {
			$contact = $this->create_contact();
			if ( 4 == $contact['status'] ) {
				return $this->get_autonami_error( $contact['message'] );
			}
			$contact_id = $contact['payload']['id'];
		}


		$order = wc_get_order( $this->data['order_id'] );
		if ( ! $order instanceof \WC_Order ) {
			return $this->get_autonami_error( 'Invalid Order' );
		}

		$deal_id = $order->get_meta( 'bwfan_hubspot_deal_id' );
		if ( intval( $deal_id ) > 0 ) {
			return $this->get_autonami_error( 'Deal already created in Hubspot.' );
		}

		/** Get Deal Id call*/
		$params = [
			"properties"       => [
				"dealname" => 'order_' . $this->data['order_id'],
				"amount"   => $order->get_total()
			],
			'bwfan_con_source' => 'autonami',
		];
		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );
		$response = $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$POST );

		if ( 4 == $response['status'] ) {
			return $this->get_autonami_error( $response['message'] );
		}
		$deal_id = $response['payload']['id'];

		/** Contact Associate with Deal call*/
		$params = [
			'api_key'          => $this->data['api_key'],
			'from_object_type' => 'contacts',
			'contact_id'       => $contact_id,
			'deal_id'          => $deal_id,
			'bwfan_con_source' => 'autonami',
		];
		$result = $this->associate_with_deal( $params );

		if ( 4 == $result['status'] ) {
			return $this->get_autonami_error( $result['message'] );
		}

		$saved_data    = \WFCO_Common::$connectors_saved_data;
		$old_data      = ( isset( $saved_data['bwfco_hubspot'] ) && is_array( $saved_data['bwfco_hubspot'] ) && count( $saved_data['bwfco_hubspot'] ) > 0 ) ? $saved_data['bwfco_hubspot'] : array();
		$saved_product = ! empty( $old_data['products'] ) ? $old_data['products'] : [];
		$connectors    = \WFCO_Load_Connectors::get_instance();

		$items         = $order->get_items();
		$line_item_ids = [];
		foreach ( $items as $item ) {
			$data  = $item->get_data();
			$name  = $data['name'];
			$price = $data['total'];
			$qty   = $data['quantity'];

			$product_id = array_search( $name, $saved_product );

			$params = [
				'api_key'          => $this->data['api_key'],
				'name'             => $name,
				'bwfan_con_source' => 'autonami',
			];
			if ( empty( $product_id ) ) {
				$product = $this->get_products_by_name( $params, $connectors );

				if ( ! empty( $product ) ) {
					$saved_product[ $product['id'] ] = $product['name'];
					$old_data['products']            = $saved_product;
				} else {
					$params['price'] = $price;
					$product         = $this->create_product( $params, $connectors );

					if ( ! empty( $product ) ) {
						$saved_product[ $product['id'] ] = $product['name'];
						$old_data['products']            = $saved_product;

						$product_id = $product['id'];
					}
				}

				//save new data
				$new_data['api_data']['api_key']  = $old_data['api_key'];
				$new_data['api_data']['products'] = $saved_product;
				$new_data['api_data']['fields']   = $old_data['fields'];
				\WFCO_Common::update_connector_data( $new_data['api_data'], $old_data['id'] );
			}
			$line_item_id = $this->create_line_item( $connectors, $product_id, $qty );
			if ( ! empty( $line_item_id ) ) {
				$line_item_ids[] = $line_item_id;
			}
		}

		/** Line items Associate with Deal */
		$params = [
			'api_key'          => $this->data['api_key'],
			'from_object_type' => 'line_items',
			'line_item_ids'    => $line_item_ids,
			'deal_id'          => $deal_id,
			'bwfan_con_source' => 'autonami',
		];
		$result = $this->associate_with_deal( $params );


		if ( 4 == $result['status'] ) {
			return $this->get_autonami_error( $result['message'] );
		}

		$order->update_meta_data( 'bwfan_hubspot_deal_id', $deal_id );
		$order->save();

		return $this->get_autonami_success( __( 'Deal Created in Hubspot.', 'autonami-automations-connectors' ) );
	}


	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/deals';
	}

}

return 'WFCO\HubSpot\Create_Deal';
