<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Get_Product_By_Name extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'name' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_get_product_by_name';
	}

	public function process_hubspot_call() {


		$param = [
			"filterGroups"     => [
				[
					"filters" => [
						[
							"propertyName" => "name",
							"operator"     => "EQ",
							"value"        => $this->data['name']
						]
					]
				]
			],
			"sorts"            => [
				"id"
			],
			"query"            => $this->data['name'],
			"properties"       => [
				"id",
				"name"
			],
			"limit"            => 1,
			"after"            => 0,
			'bwfan_con_source' => 'autonami'
		];

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $param ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/products/search';
	}

}

return 'WFCO\HubSpot\Get_Product_By_Name';
