<?php

#[AllowDynamicProperties]
final class BWFAN_Klaviyo_Update_List_Subscribe_Status extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Update List Subscribe Status', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'Update List Subscribe Status', 'autonami-automations-connectors' );
		$this->action_priority = 10;
		$this->support_v2      = true;
		$this->support_v1      = false;

	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function get_view_data() {
		return WFCO_Common::get_single_connector_data( $this->connector, 'lists' );
	}


	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object
	 * @param $task_meta
	 *
	 * @return array|void
	 */

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set                  = array();
		$data_to_set['api_key']       = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['list_id']       = $step_data['list_id'];
		$data_to_set['sms_consent']   = isset( $step_data['sms_consent'] ) ? $step_data['sms_consent'] : 0;
		$data_to_set['email_consent'] = isset( $step_data['email_consent'] ) ? $step_data['email_consent'] : 0;
		$data_to_set['email']         = isset( $automation_data['global']['email'] ) ? $automation_data['global']['email'] : '';

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		/** Set phone number if not set */
		if ( ! empty( $data_to_set['sms_consent'] ) && ! empty( $data_to_set['email'] ) ) {
			$contact              = new BWFCRM_Contact( $data_to_set['email'] );
			$data_to_set['phone'] = $contact->is_contact_exists() ? $contact->contact->get_contact_no() : '';
		}

		/** set country code in case of order and  cart abandoned event */
		if ( isset( $automation_data['global'] ) && isset( $automation_data['global']['order_id'] ) ) {
			$data_to_set['order_id'] = $automation_data['global']['order_id'];
		} elseif ( isset( $automation_data['global'] ) && isset( $automation_data['global']['cart_abandoned_id'] ) ) {
			$data_to_set['cart_abandoned_id'] = $automation_data['global']['cart_abandoned_id'];
		}

		return $data_to_set;
	}

	public function handle_response_v2( $result ) {
		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		/** If success (within 200 status), then return payload (actual response) and status, message */
		if ( ( absint( $result['response'] ) - 200 ) < 100 ) {
			return $this->success_message( __( 'Klaviyo API call executed successfully', 'autonami-automations-connectors' ) );
		}

		$klaviyo_error = "";
		$unknown_error = "";
		/** If failed, send appropriate error */
		$response_code = __( '. Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		if ( isset( $result['body']['message'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['message'] . ', Code: ' . $result['response'];
		}
		if ( isset( $result['body']['detail'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['detail'] . ', Code: ' . $result['response'];
		}

		if ( empty( $klaviyo_error ) ) {
			$unknown_error = __( 'Unknown Klaviyo Error', 'autonami-automations-connectors' ) . $response_code;
		}

		return $this->error_response( ( false !== $klaviyo_error ? $klaviyo_error : $unknown_error ) );
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$lists = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $this->get_view_data() ) );

		return [
			[
				'id'          => 'list_id',
				'label'       => __( "Select List", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $lists,
				'placeholder' => "Select",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => '',
				"hint"        => __( "Klaviyo list has an <b>Opt-in process</b> setting. If <b>Single opt-in</b> then the list will be assigned directly and if <b>Double opt-in</b>, the user needs to verify from email.", 'autonami-automations-connectors' ),
				"required"    => true,
			],
			[
				'id'            => 'email_consent',
				'checkboxlabel' => __( "Email Consent", 'autonami-automations-connectors' ),
				'type'          => 'checkbox',
				"class"         => 'bwfan-input-wrapper',
				'tip'           => __( '', 'autonami-automations-connectors' ),
				"description"   => '',
				"required"      => false,
			],
			[
				'id'            => 'sms_consent',
				'checkboxlabel' => __( "SMS Consent", 'autonami-automations-connectors' ),
				'type'          => 'checkbox',
				"class"         => 'bwfan-input-wrapper',
				'tip'           => __( '', 'autonami-automations-connectors' ),
				"description"   => '',
				"required"      => false,
			],

		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['list_id'] ) || empty( $data['list_id'] ) ) {
			return '';
		}

		$lists = $this->get_view_data();
		if ( ! isset( $lists[ $data['list_id'] ] ) || empty( $lists[ $data['list_id'] ] ) ) {
			return '';
		}

		return $lists[ $data['list_id'] ];
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Klaviyo_Update_List_Subscribe_Status';
