<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Get_Profile extends WFCO_Klaviyo_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct();
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_get_profile';
	}

	public function process_klaviyo_call() {
		return $this->do_klaviyo_call( [], \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Klaviyo::$api_end_point . 'profiles/?filter=equals(email,"' . $this->data['email'] . '")';
	}

}

return 'WFCO\Klaviyo\Get_Profile';
