<?php

#[AllowDynamicProperties]
final class BWFAN_Mailchimp_Update_Contact_Status extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Update contact status', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action update status of contact', 'autonami-automations-connectors' );
		$this->action_priority = 30;
		$this->support_v2      = true;
		$this->support_v1      = false;
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function get_view_data() {
		return WFCO_Common::get_single_connector_data( $this->connector, 'lists' );
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set            = array();
		$data_to_set['api_key'] = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['list_id'] = $step_data['list_id'];
		$data_to_set['email']   = $automation_data['global']['email'];
		$data_to_set['status']  = $step_data['status'];

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	public function handle_response_v2( $result ) {
		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		if ( isset( $result['response'] ) && 200 === absint( $result['response'] ) ) {
			return $this->success_message( __( 'Contact status updated successfully!', 'autonami-automations-connectors' ) );
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return $this->error_response( isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$error_title     = ( is_array( $result['body'] ) && isset( $result['body']['detail'] ) ) ? $result['body']['detail'] : false;
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return $this->error_response( ( false !== $error_title ? $error_title : $unknown_message ) . $response_code );

	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$lists    = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $this->get_view_data() ) );
		$statuses = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], WFCO_Mailchimp_Common::get_status_view_data() ) );

		return [
			[
				'id'          => 'status',
				'label'       => __( "Select Status", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $statuses,
				'placeholder' => "Select",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( 'This will update the Status of the contact.', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
			[
				'id'          => 'list_id',
				'label'       => __( "Select List", 'autonami-automations-connectors' ),
				'type'        => 'select',
				'options'     => $lists,
				'placeholder' => "Select",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( 'In case of a new contact, contact will be added to the given list.', 'autonami-automations-connectors' ),
				"description" => '',
				"hint"        => __( 'For New Contacts only', 'autonami-automations-connectors' ),
				"required"    => true,
			],
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['list_id'] ) || empty( $data['list_id'] ) ) {
			return '';
		}

		$lists = $this->get_view_data();
		if ( ! isset( $lists[ $data['list_id'] ] ) || empty( $lists[ $data['list_id'] ] ) ) {
			return '';
		}

		return $lists[ $data['list_id'] ];
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Mailchimp_Update_Contact_Status';
