<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

#[AllowDynamicProperties]
class BWFAN_SL_Users {
	
	private static $ins = null;
	
	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function get_slug() {
		return 'sl_users';
	}

	public function get_options( $search ) {
		//BWFAN_SL_Message_User
		$action = BWFAN_Core()->integration->get_action( 'sl_message_user' );

		if ( ! $action instanceof BWFAN_Action ) {
			return [];
		}

		$data = $action->get_view_data();

		if ( ! method_exists( 'BWFAN_PRO_Common', 'search_srting_from_data' ) ) {
			return [];
		}

		return BWFAN_PRO_Common::search_srting_from_data( $data, $search );
	}

}

if ( class_exists('BWFAN_Load_Custom_Search') ) {
	BWFAN_Load_Custom_Search::register( 'BWFAN_SL_Users' );
}

