<?php
/**
 * Twilio SMS unsubscribe Webhook Handler Controller Class
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFAN_Twilio_SMS_Unsubscribe
 *
 */
#[\AllowDynamicProperties]
class BWFAN_Twilio_SMS_Unsubscribe {

	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		add_action( 'rest_api_init', [ $this, 'register_routes' ] );
	}

	public function register_routes() {
		register_rest_route( 'autonami-webhook', '/sms/twilio/(?P<key>[a-zA-Z0-9-]+)', [
			array(
				'methods'             => 'POST',
				'callback'            => array( $this, 'handle_webhook' ),
				'permission_callback' => '__return_true'
			),
			array(
				'methods'             => 'GET',
				'callback'            => array( $this, 'handle_webhook' ),
				'permission_callback' => '__return_true'
			)
		] );
	}

	public function handle_webhook( WP_REST_Request $request ) {

		$query_params   = $request->get_query_params();
		$query_params   = is_array( $query_params ) ? $query_params : array();
		$request_params = $request->get_params();
		$request_params = is_array( $request_params ) ? $request_params : array();
		$json_params    = $request->get_json_params();
		$json_params    = is_array( $json_params ) ? $json_params : array();
		$params         = array_replace( $query_params, $request_params );
		$params         = array_replace( $params, $json_params );

		/** Log webhook Request - Dev only */
		if ( ( defined( 'BWFAN_SMS_Webhook_Log_Data' ) && true === BWFAN_SMS_Webhook_Log_Data ) || true === apply_filters( 'BWFAN_SMS_Webhook_Log_Data', false, $params ) ) {
			BWFAN_Common::log_test_data( 'Twilio SMS Webhook data: ' . $params['api_key'], 'crm-sms-webhooks', true );
			BWFAN_Common::log_test_data( $params, 'crm-sms-webhooks', true );
		}

		/**
		 * return if it is just the normal message and not for unsubscribe
		 * just checking one single string 'STOP', if sms contain stop along with other strings,
		 * then contact will not be unsubscribed. Sms should contain only 'STOP' in capital letters
		 */
		if ( 'STOP' !== strtoupper( trim( strval( $params['Body'] ) ) ) ) {
			wp_send_json_error( [
				'message' => 'STOP text not found'
			] );
		}

		$unique_key = get_option( 'bwfan_u_key', 0 );
		if ( ! isset( $params['key'] ) || empty( $unique_key ) || $unique_key !== $params['key'] ) {
			BWFAN_Core()->logger->log( 'Twilio SMS Webhook prevented: Invalid unique key', 'crm_sms_webhooks' );

			wp_send_json_error( [
				'message' => 'Invalid Key.'
			] );
		}

		/** if from empty */
		if ( empty( $params['From'] ) ) {
			wp_send_json_error( [
				'message' => 'Invalid From number.'
			] );
		}

		$cid = BWFAN_Connectors_Common::get_cid_from_contact( '', '', $params['From'] );
		if ( empty( $cid ) ) {
			wp_send_json_error( [
				'message' => 'No Contact found with Contact number: ' . $params['From'],
			] );
		}

		$contact = new WooFunnels_Contact( '', '', '', $cid );
		$phone   = $contact->get_contact_no();

		/** check if the contact phone number already unsubscribe */
		$unsubscribe_data = BWFAN_Model_Message_Unsubscribe::get_specific_rows( 'recipient', $phone, 0, 1 );

		if ( ! empty( $unsubscribe_data[0] ) ) {
			wp_send_json_error( [
				'message' => 'Contact already unsubscribe with Contact number: ' . $phone,
			] );
		}

		/** to mark contact phone number unsubscribe */
		$insert_data = array(
			'recipient'     => $phone,
			'c_date'        => current_time( 'mysql' ),
			'mode'          => 2,
			'automation_id' => 0,
			'c_type'        => 0,
		);

		BWFAN_Model_Message_Unsubscribe::insert( $insert_data );

		wp_send_json( [
			'message' => 'Contact phone number unsubscribed'
		], 200 );
	}

	public function get_webhooks() {
		$unique_key = get_option( 'bwfan_u_key', 0 );
		$namespace  = 'autonami-webhook';
		$webhooks   = [
			'name' => 'Twilio',
			'link' => add_query_arg( array(), rest_url( "$namespace/sms/twilio/$unique_key" ) )
		];

		return $webhooks;
	}
}

BWFAN_Twilio_SMS_Unsubscribe::get_instance();
