<?php

#[AllowDynamicProperties]
class BWFCO_Bitly extends BWF_CO {

	private static $ins = null;
	private $option_key = 'bwfan_bitly_service_data';
	public $v2 = true;
	public static $headers = null;

	private function __construct() {
		$this->dir               = __DIR__;
		$this->is_setting        = true;
		$this->autonami_int_slug = 'bitly_service';
		$this->connector_url     = WFCO_AUTONAMI_CONNECTORS_PLUGIN_URL . '/connectors/bitly';
		$this->nice_name         = __( 'Bitly', 'autonami-automations-connectors' );

		add_action( 'admin_menu', array( $this, 'process_url' ) );
		add_action( 'admin_menu', array( $this, 'disconnect_from_query_string' ) );
		add_shortcode( 'bwfan_bitly_shorten', array( $this, 'bwfan_shorten' ) );

		add_filter( 'wfco_do_not_print_connector_button', array( $this, 'dont_print_native_card_buttons' ), 10, 2 );
		add_action( 'wfco_print_connector_button_placeholder', array( $this, 'print_own_button_in_card_ui' ) );
		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );

		/**
		 * adding this services using filter
		 */
		add_filter( 'bwfan_shortener_services', array( $this, 'add_as_shortener_service' ), 10, 1 );
	}

	public static function get_instance() {
		if ( is_null( self::$ins ) ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function set_headers( $access_token ) {
		$headers = array(
			'Authorization' => 'Bearer ' . $access_token,
			'Content-Type'  => 'application/json',
		);

		self::$headers = $headers;
	}

	public static function get_headers() {
		return self::$headers;
	}

	public function dont_print_native_card_buttons( $status, $slug ) {
		if ( $this->get_slug() === $slug ) {
			$status = true;
		}

		return $status;
	}

	public function print_own_button_in_card_ui() {
		include __DIR__ . '/views/settings.php';
	}

	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_bitly'] = array(
			'name'            => 'Bitly',
			'desc'            => __( 'Shorten the URLs to get increased character limit for SMS.', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFAN_Service_Bitly',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	public function get_url() {
		$url = 'https://secure-auth.buildwoofunnels.com/bitly/';
		$url = add_query_arg( array(
			'redirect_uri' => urlencode( admin_url( 'admin.php?page=autonami&tab=connector' ) ),
		), $url ); //phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions

		return $url;
	}

	public function process_url() {
		//phpcs:disable WordPress.Security.ValidatedSanitizedInput, WordPress.Security.NonceVerification
		if ( isset( $_REQUEST['access_token'] ) && isset( $_REQUEST['login'] ) && isset( $_REQUEST['bitly'] ) ) {
			$data = array(
				'access_token' => sanitize_text_field( $_REQUEST['access_token'] ),
				'login'        => sanitize_text_field( $_REQUEST['login'] ),
			);
			update_option( $this->option_key, $data );
		}
		//phpcs:enable WordPress.Security.ValidatedSanitizedInput, WordPress.Security.NonceVerification
	}

	public function disconnect_from_query_string() {
		if ( isset( $_REQUEST['bitly_disconnect'] ) ) { //phpcs:ignore WordPress.Security.ValidatedSanitizedInput, WordPress.Security.NonceVerification
			update_option( $this->option_key, array() );
			wp_safe_redirect( admin_url( 'admin.php?page=autonami&tab=connector' ) );
			exit;
		}
	}

	public function disconnect() {
		update_option( $this->option_key, array() );
	}

	public function get_disconnect_url() {
		return admin_url( 'admin.php?page=autonami&tab=connector&bitly_disconnect=true' );
	}

	public function bwfan_shorten( $attr, $content = '' ) {
		$content = do_shortcode( $content );
		$content = $this->generate_shorten_url( $content );

		return $content;
	}

	public function generate_shorten_url( $link ) {
		$link = trim( $link );
		if ( empty( $link ) ) {
			return '';
		}

		if ( false === filter_var( $link, FILTER_VALIDATE_URL ) ) {
			return $link;
		}

		$setting = $this->get_saved_data();
		if ( empty( $setting ) ) {
			return $link;
		}


		$data = array(
			'access_token' => isset( $setting['access_token'] ) ? $setting['access_token'] : '',
			'url'          => $link
		);

		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_bitly_shorten_url' );

		if ( is_null( $call_class ) ) {
			return $link;
		}

		$call_class->set_data( $data );
		$shorten_res = $call_class->process();

		if ( ! is_array( $shorten_res ) || 200 !== $shorten_res['response'] ) {
			return $link;
		}

		if ( ! isset( $shorten_res['body']['link'] ) || empty( $shorten_res['body']['link'] ) ) {
			return $link;
		}

		return $shorten_res['body']['link'];
	}

	public function get_saved_data() {
		return get_option( 'bwfan_bitly_service_data', array() );
	}

	public function get_initial_schema() {
		return array(
			array(
				'id'       => 'slack_connect',
				'type'     => 'para',
				'class'    => 'bwfan_slack_info',
				'required' => false,
				'children' => "Click on 'Connect' to connect your Bitly to this store",
			),
		);
	}

	public function get_fields_schema() {
		return array(
			array(
				'id'       => 'slack_connect',
				'type'     => 'para',
				'class'    => 'bwfan_slack_info',
				'required' => false,
				'children' => ! $this->is_connected() ? "Click on 'Connect' to connect your Bitly to this store" : 'Already Connected. To reconnect, press the disconnect button and connect again.',
			),
		);
	}

	public function get_settings_fields_values() {
		return array();
	}

	public function get_meta_data() {
		return array(
			'connect_type' => 'redirect_url',
			'redirect_url' => $this->get_url(),
		);
	}

	public function is_connected() {
		return ! empty( get_option( 'bwfan_bitly_service_data', array() ) );
	}

	/**
	 * Add this integration to Shortener services list.
	 *
	 * @param $services
	 *
	 * @return array
	 */
	public function add_as_shortener_service( $services ) {
		$slug = $this->get_slug();

		if ( BWFAN_Core()->connectors->is_connected( $slug ) ) {
			$services[ $slug ] = $this->nice_name;
		}

		return $services;
	}

}

WFCO_Load_Connectors::register( 'BWFCO_Bitly' );
