<?php

#[AllowDynamicProperties]
final class BWFAN_Bulkgate_Integration extends BWFAN_Integration {
	private static $ins = null;
	protected $connector_slug = 'bwfco_bulkgate';
	protected $need_connector = true;

	private function __construct() {
		$this->action_dir = __DIR__;
		$this->nice_name  = __( 'BulkGate', 'autonami-automations-connectors' );
		$this->group_name = __( 'Messaging', 'autonami-automations-connectors' );
		$this->group_slug = 'messaging';
		$this->priority   = 55;

		add_filter( 'bwfan_sms_services', array( $this, 'add_as_sms_service' ), 10, 1 );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	protected function do_after_action_registration( BWFAN_Action $action_object ) {
		$action_object->connector = $this->connector_slug;
	}

	/**
	 * Add this integration to SMS services list.
	 *
	 * @param $sms_services
	 *
	 * @return array
	 */
	public function add_as_sms_service( $sms_services ) {
		$slug = $this->get_connector_slug();
		if ( BWFAN_Core()->connectors->is_connected( $slug ) ) {
			$integration                  = $slug;
			$sms_services[ $integration ] = $this->nice_name;
		}

		return $sms_services;
	}

	/** All SMS Providers must expose this function as API to send message */
	public function send_message( $args ) {
		$args = wp_parse_args( $args, array(
			'to'        => '',
			'body'      => '',
			'image_url' => '',
		) );

		$to   = $args['to'];
		$body = $args['body'];
		if ( empty( $to ) || empty( $body ) ) {
			return new WP_Error( 400, 'Data missing to send BulkGate SMS' );
		}

		$bulkgate_data['data']['sms_body_textarea'] = $body;
		$bulkgate_data['data']['sms_to']            = $to;

		if ( isset( $args['is_test'] ) && ! empty( $args['is_test'] ) ) {
			/** @var set property progress of action to true to decode the url in bitly */
			$sms_ni_ins = BWFAN_Bulkgate_Send_Transactional_Sms::get_instance();
			$sms_ni_ins->set_progress( true );
		}

		WFCO_Common::get_connectors_data();
		$settings          = WFCO_Common::$connectors_saved_data[ $this->get_connector_slug() ];
		$application_id    = $settings['application_id'];
		$application_token = $settings['application_token'];
		$sender_id         = $settings['sender_id'];
		if ( empty( $application_id ) || empty( $application_token ) ) {
			return new WP_Error( 404, 'Invalid / Missing saved connector data' );
		}

		$call_args = array(
			'application_id'    => $application_id,
			'application_token' => $application_token,
			'text'              => $body,
			'number'            => $to
		);

		if ( ! empty( $sender_id ) ) {
			$call_args['sender_id'] = $sender_id;
		}
		// $image_url = $args['image_url'];
		// if ( ! empty( $image_url ) && filter_var( $image_url, FILTER_VALIDATE_URL ) ) {
		// $call_args['mediaUrl'] = $image_url;
		// }

		$load_connectors = WFCO_Load_Connectors::get_instance();
		$call            = $load_connectors->get_call( 'wfco_bulkgate_send_transactional_sms' );
		$call->set_data( $call_args );

		return $this->validate_send_message_response( $call->process() );
	}

	public function validate_send_message_response( $response ) {
		if ( is_array( $response ) && ( ( isset( $response['response'] ) && 200 === absint( $response['response'] ) ) || ( isset( $response['status'] ) && 3 === absint( $response['status'] ) ) ) ) {
			return true;
		}

		$message = __( 'SMS could not be sent. ', 'autonami-automations-connectors' );

		if ( isset( $response['body']['error'] ) ) {
			$message = $response['body']['error'];
		} elseif ( isset( $response['body']['message'] ) ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['message'] ) ) {
			$message = $response['message'];
		} elseif ( isset( $response['bwfan_response'] ) && ! empty( $response['bwfan_response'] ) ) {
			$message = $response['bwfan_response'];
		} elseif ( is_array( $response['body'] ) && isset( $response['body'][0] ) && is_string( $response['body'][0] ) ) {
			$message = $message . $response['body'][0];
		}

		return new WP_Error( 500, $message );
	}
}

/**
 * Register this class as an integration.
 */
BWFAN_Load_Integrations::register( 'BWFAN_Bulkgate_Integration' );
