<?php

#[AllowDynamicProperties]
class BWFCO_Ever_WebinarJam extends BWF_CO {
	public static $headers = null;
	private static $ins = null;
	public $v2 = true;


	public function __construct() {
		/** Connector.php initialization */
		$this->keys_to_track = [
			'api_key'
		];
		$this->form_req_keys = [
			'api_key'
		];

		/**
		 * Load important variables and constants
		 */
		$this->define_plugin_properties();

		/**
		 * Loads common file
		 */
		$this->init_ever_webinarjam();

		$this->sync              = true;
		$this->connector_url     = WFCO_EVER_WEBINARJAM_PLUGIN_URL;
		$this->dir               = __DIR__;
		$this->nice_name         = __( 'Ever_WebinarJam', 'autonami-automations-connectors' );
		$this->autonami_int_slug = 'BWFAN_Ever_WebinarJam_Integration';

		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );
	}

	/**
	 * Defining constants
	 */
	public function define_plugin_properties() {
		define( 'WFCO_EVER_WEBINARJAM_VERSION', '1.0.0' );
		define( 'WFCO_EVER_WEBINARJAM_FULL_NAME', 'FunnelKit Automations Connectors: WebinarJam/EverWebinar' );
		define( 'WFCO_EVER_WEBINARJAM_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_EVER_WEBINARJAM_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_EVER_WEBINARJAM_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_EVER_WEBINARJAM_PLUGIN_FILE ) ) );
		define( 'WFCO_EVER_WEBINARJAM_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_EVER_WEBINARJAM_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_EVER_WEBINARJAM_ENCODE', sha1( WFCO_EVER_WEBINARJAM_PLUGIN_BASENAME ) );
	}

	/**
	 * initiating ever_webinarjam
	 */
	public function init_ever_webinarjam() {
		require WFCO_EVER_WEBINARJAM_PLUGIN_DIR . '/includes/class-wfco-ever-webinarjam-common.php';
	}

	/**
	 * connector settings view field schema
	 * @return array[]
	 */
	public function get_fields_schema() {
		return array(
			array(
				'id'          => 'api_key',
				'label'       => __( 'API Key', 'autonami-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_ever_webinarjam_api_key',
				'placeholder' => __( 'API Key', 'autonami-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			),
		);
	}

	/**
	 * connector settings view field values
	 * @return array
	 */
	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();
		$vals       = array();
		if ( isset( $old_data['api_key'] ) ) {
			$vals['api_key'] = $old_data['api_key'];
		}

		return $vals;
	}

	/**
	 * Get data from the API call, must required function otherwise call
	 *
	 * @param $posted_data
	 *
	 * @return array
	 */
	protected function get_api_data( $posted_data ) {
		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_webinarjam_oauth_check' );

		$resp_array = array(
			'api_data' => $posted_data,
			'status'   => 'failed',
			'message'  => __( 'There was problem authenticating your account. Confirm entered details.', 'autonami-automations-connectors' ),
		);

		if ( is_null( $call_class ) ) {
			return $resp_array;
		}

		$data = array(
			'api_key' => isset( $posted_data['api_key'] ) ? $posted_data['api_key'] : ''
		);

		$call_class->set_data( $data );
		$webinar_list = $call_class->process();

		$response = [ 'api_data' => [] ];

		$response['api_data']['api_key'] = $posted_data['api_key'];

		if ( is_array( $webinar_list ) && 200 === $webinar_list['response'] ) {
			$response['status']               = 'success';
			$response['api_data']['webinars'] = $webinar_list['body']['webinars'];
		}

		$ever_webinars = $this->get_everwebinars( $posted_data['api_key'] );

		if ( is_array( $ever_webinars ) && 200 === $ever_webinars['response'] ) {
			$response['status']                    = 'success';
			$response['api_data']['ever_webinars'] = $ever_webinars['body']['webinars'];
		}

		// return if status is success
		if ( 'success' === $response['status'] ) {
			// creating field - Last meeting Link.
			BWFCRM_Fields::add_field( 'Last Meeting Link', 1, [], 'Last Meeting Link', 1, 1, 1, '0' );
			return $response;
		}

		$resp_array           = [];
		$resp_array['status'] = 'failed';

		// return if got any error
		if ( ( is_array( $webinar_list ) && 401 === $webinar_list['response'] ) || ( is_array( $ever_webinars ) && 401 === $ever_webinars['response'] ) ) {
			$resp_array['message'] = ( isset( $webinar_list['body']['errors']['api_key'] ) ) ? $webinar_list['body']['errors']['api_key'] : ( $ever_webinars['body']['errors']['api_key'] ? $ever_webinars['body']['errors']['api_key'] : __( 'Undefined Api Error', 'autonami-automations-connectors' ) );

			return $resp_array;
		}

		$resp_array['message'] = ( isset( $webinar_list['body']['errors'] ) ) ? $webinar_list['body']['errors'] : ( isset( $ever_webinars['body']['errors'] ) ? $ever_webinars['body']['errors'] : __( 'Undefined Api Error', 'autonami-automations-connectors' ) );

		return $resp_array;
	}

	public function get_everwebinars( $api_key ) {
		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_everwebinar_get_webinars' );

		$resp_array = array();

		if ( is_null( $call_class ) ) {
			return $resp_array;

		}

		$data = array(
			'api_key' => isset( $api_key ) ? $api_key : ''
		);

		$call_class->set_data( $data );

		return $call_class->process();
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * @param $available_connectors
	 * Connectors view
	 *
	 * @return mixed
	 */
	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_ever_webinarjam'] = array(
			'name'            => 'WebinarJam / EverWebinar',
			'desc'            => __( 'Register a person to a specific webinar', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFCO_EVER_WEBINARJAM',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}
}

WFCO_Load_Connectors::register( 'BWFCO_Ever_WebinarJam' );
