<?php

namespace WFCO\GetResponse;

#[\AllowDynamicProperties]
class Get_Tags extends \WFCO_Call {

	private static $ins = null;

	public function __construct() {

		$this->required_fields = array( 'api_key' );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_gr_get_tags';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		\BWFCO_GetResponse::set_headers( $this->data['api_key'] );
		$params = array( 'bwfan_con_source' => 'autonami', 'get_method' => true );

		return $this->make_wp_requests( $this->get_endpoint(), $params, \BWFCO_GetResponse::get_headers(), \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint() {
		return \BWFCO_GetResponse::get_endpoint() . 'tags';
	}

}

return 'WFCO\GetResponse\Get_Tags';
