<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Add_Contact_To_Workflow extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( [ 'api_key', 'email', 'workflow_id' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_add_contact_to_workflow';
	}

	public function process_hubspot_call() {
		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$is_email_available = $this->get_contact_by_email();

		if ( empty( $is_email_available ) ) {
			$contact = $this->create_contact();
			if ( 4 == $contact['status'] ) {
				return $this->get_autonami_error( $contact['message'] );
			}
		}

		$params['bwfan_con_source'] = 'autonami';

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'automation/v2/workflows/' . $this->data['workflow_id'] . '/enrollments/contacts/' . $this->data['email'];
	}

}

return 'WFCO\HubSpot\Add_Contact_To_Workflow';
