<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Associate_Line_Item_With_Deal extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( [ 'api_key', 'from_object_type', 'deal_id' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_associate_line_item_with_deal';
	}

	public function process_hubspot_call() {

		$params['bwfan_con_source'] = 'autonami';
		if ( ! empty( $this->data['line_item_ids'] ) ) {
			$line_item_ids = $this->data['line_item_ids'];
			foreach ( $line_item_ids as $line_item_id ) {
				$params['inputs'][] = [
					"from" => [ "id" => $line_item_id ],
					"to"   => [ "id" => $this->data['deal_id'] ],
					"type" => "line_item_to_deal"
				];
			}
		}

		if ( ! empty( $this->data['contact_id'] ) ) {
			$params['inputs'][] = [
				"from" => [ "id" => $this->data['contact_id'] ],
				"to"   => [ "id" => $this->data['deal_id'] ],
				"type" => "contact_to_deal"
			];
		}

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {

		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/associations/' . $this->data['from_object_type'] . '/deals/batch/create';
	}

}

return 'WFCO\HubSpot\Associate_Line_Item_With_Deal';
