<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Create_Contact_List extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'name' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_create_contact_list';
	}

	public function process_hubspot_call() {

		$params = [ 'name' => $this->data['name'], 'bwfan_con_source' => 'autonami' ];

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( $params, \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'contacts/v1/lists';
	}

}

return 'WFCO\HubSpot\Create_Contact_List';
