<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Create_Product extends WFCO_Hubspot_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'name', 'price' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_create_product';
	}

	public function process_hubspot_call() {

		$params = [
			"properties"       => [
				"name"  => $this->data['name'],
				"price" => $this->data['price']
			],
			'bwfan_con_source' => 'autonami',
		];

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/products';
	}

}

return 'WFCO\HubSpot\Create_Product';
