<?php

#[AllowDynamicProperties]
class BWFCO_Hubspot extends BWF_CO {
	public static $api_end_point = 'https://api.hubapi.com/';
	public static $headers = null;
	private static $ins = null;
	public $v2 = true;

	public function __construct() {

		/**
		 * Load important variables and constants
		 */
		$this->define_plugin_properties();

		/**
		 * Loads common file
		 */
		$this->load_commons();

		/** Connector.php initialization */
		$this->keys_to_track = [
			'api_key',
			'products',
			'fields',
			'lists',
			'workflows'
		];
		$this->form_req_keys = [
			'api_key',
		];

		$this->sync          = true;
		$this->connector_url = WFCO_HUBSPOT_PLUGIN_URL;
		$this->dir           = __DIR__;
		$this->nice_name     = __( 'Hubspot', 'autonami-automations-connectors' );

		$this->autonami_int_slug = 'BWFAN_Hubspot_Integration';
		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );
	}

	public function define_plugin_properties() {
		define( 'WFCO_HUBSPOT_VERSION', '1.0.0' );
		define( 'WFCO_HUBSPOT_FULL_NAME', 'FunnelKit Automations Connectors: Hubspot' );
		define( 'WFCO_HUBSPOT_PLUGIN_FILE', __FILE__ );
		define( 'WFCO_HUBSPOT_PLUGIN_DIR', __DIR__ );
		define( 'WFCO_HUBSPOT_PLUGIN_URL', untrailingslashit( plugin_dir_url( WFCO_HUBSPOT_PLUGIN_FILE ) ) );
		define( 'WFCO_HUBSPOT_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
		define( 'WFCO_HUBSPOT_MAIN', 'autonami-automations-connectors' );
		define( 'WFCO_HUBSPOT_ENCODE', sha1( WFCO_HUBSPOT_PLUGIN_BASENAME ) );
	}

	/**
	 * Load common files
	 */
	public function load_commons() {
		require WFCO_HUBSPOT_PLUGIN_DIR . '/includes/class-wfco-hubspot-call.php';
		require WFCO_HUBSPOT_PLUGIN_DIR . '/includes/class-wfco-hubspot-webhook-setup.php';
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function get_headers() {
		return self::$headers;
	}

	public static function set_headers( $api_key ) {
		$headers = array(
			'Content-Type'  => 'application/json',
			'Authorization' => 'Bearer ' . $api_key,
		);

		self::$headers = $headers;
	}

	/**
	 * This function connects to the automation and fetch the data required for the actions on automations screen to work properly.
	 *
	 * @param $posted_data
	 *
	 * @return array|int
	 */
	public function get_api_data( $posted_data ) {
		$resp_array                        = array();
		$resp_array['api_data']['api_key'] = isset( $posted_data['api_key'] ) ? $posted_data['api_key'] : '';
		$resp_array['status']              = 'success';

		if ( ! isset( $posted_data['api_key'] ) || empty( $posted_data['api_key'] ) ) {
			return $resp_array;
		}

		$params = array(
			'api_key'          => $posted_data['api_key'],
			'bwfan_con_source' => 'autonami'
		);

		/** Fetch Products */
		$products = $this->fetch_products( $params );
		if ( is_array( $products ) && count( $products ) > 0 ) {
			$resp_array['api_data']['products'] = $products;
		}

		/** Fetch Contact fields */
		$fields = $this->fetch_contact_fields( $params );
		if ( is_array( $fields ) && count( $fields ) > 0 ) {
			$resp_array['api_data']['fields'] = $fields;
		}

		/** Fetch Contact Lists */
		$lists = $this->fetch_contact_lists( $params );
		if ( is_array( $lists ) && count( $lists ) > 0 ) {
			$resp_array['api_data']['lists'] = $lists;
		}

		/** Fetch Wrokflows */
		$workflows = $this->fetch_workflows( $params );
		if ( is_array( $workflows ) && count( $workflows ) > 0 ) {
			if ( isset( $workflows['code'] ) && 403 === $workflows['code'] ) {
				$workflows = $workflows['message'];
			}
			$resp_array['api_data']['workflows'] = $workflows;
		}

		return $resp_array;
	}

	/**
	 * Fetch Hubspot Products
	 *
	 * @param $params
	 *
	 * @return array
	 */
	public function fetch_products( $params, $captured_items = [] ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\HubSpot\Get_Products $call */
		$call = $connectors->get_call( 'wfco_hubspot_get_products' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 4 === ( $result['status'] ) || ( isset( $result['payload']['status'] ) && 'error' === $result['payload']['status'] ) ) {
			wp_send_json( array(
				'status'  => 'failed',
				'message' => $result['message'],
			) );

			exit;
		}

		$prods = $result['payload']['results'];
		foreach ( $prods as $product ) {
			$id                    = $product['id'];
			$captured_items[ $id ] = $product['properties']['name'];
		}

		$all_products = $captured_items;
		if ( count( $prods ) > 0 && isset( $result['payload']['paging']['next'] ) ) {
			$params['after'] = $result['payload']['paging']['next']['after'];

			return $this->fetch_products( $params, $all_products );
		}

		return $all_products;
	}

	function fetch_contact_fields( $params ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		// /** @var WFCO_Hubspot_Get_Contact_Properties $call */
		$call = $connectors->get_call( 'wfco_hubspot_get_contact_properties' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 4 === ( $result['status'] ) || ( isset( $result['payload']['status'] ) && 'error' === $result['payload']['status'] ) ) {
			wp_send_json( array(
				'status'  => 'failed',
				'message' => $result['message'],
			) );

			exit;
		}

		$data       = $result['payload']['results'];
		$properties = [];

		foreach ( $data as $property ) {
			if ( empty( $property['formField'] ) ) {
				continue;
			}
			$properties[ $property['name'] ] = $property['label'];
		}

		return $properties;
	}

	public function fetch_contact_lists( $params, $captured_items = [] ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		/** @var WFCO\HubSpot\Get_Contact_Lists $call */
		$call = $connectors->get_call( 'wfco_hubspot_get_contact_lists' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 4 === ( $result['status'] ) || ( isset( $result['payload']['status'] ) && 'error' === $result['payload']['status'] ) ) {
			wp_send_json( array(
				'status'  => 'failed',
				'message' => $result['message'],
			) );

			exit;
		}

		$lists = $result['payload']['lists'];
		foreach ( $lists as $list ) {
			$id                    = $list['listId'];
			$captured_items[ $id ] = $list['name'];
		}

		$all_lists = $captured_items;
		if ( count( $lists ) > 0 && ! empty( $result['payload']['has-more'] ) ) {
			$params['offset'] = $result['payload']['offset'];

			return $this->fetch_contact_lists( $params, $all_lists );
		}

		return $all_lists;
	}

	public function fetch_workflows( $params ) {
		$connectors = WFCO_Load_Connectors::get_instance();
		// /** @var WFCO_Hubspot_Get_Workflows $call */
		$call = $connectors->get_call( 'wfco_hubspot_get_workflows' );
		$call->set_data( $params );
		$result = $call->process();

		if ( 4 === $result['status'] ) {
			wp_send_json( array(
				'status'  => 'failed',
				'message' => $result['message'],
			) );

			exit;
		}

		if ( isset( $result['code'] ) && 403 === $result['code'] ) {

			return $result;
		}

		$data      = $result['payload']['workflows'];
		$workflows = [];
		foreach ( $data as $workflow ) {
			if ( ! empty( $workflow['enabled'] ) ) {
				$workflows[ $workflow['id'] ] = $workflow['name'];
			}
		}

		return $workflows;
	}


	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_hubspot'] = array(
			'name'            => 'Hubspot',
			'desc'            => __( 'Create Contact, Add contact to list, Remove From list, update Contact fields and much more..', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFCO_Hubspot',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	public function get_fields_schema() {
		return array(
			array(
				'id'          => 'api_key',
				'label'       => __( 'Enter API KEY', 'autonami-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_hub_api_key',
				'placeholder' => __( 'Enter API KEY', 'autonami-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			)
		);
	}

	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();

		$vals = array();
		if ( isset( $old_data['api_key'] ) ) {
			$vals['api_key'] = $old_data['api_key'];
		}

		return $vals;
	}
}

WFCO_Load_Connectors::register( 'BWFCO_Hubspot' );
