<?php

#[AllowDynamicProperties]
final class BWFAN_Keap_Update_Contact_Fields extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Update Contact Fields', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action adds / updates the custom fields of the contact', 'autonami-automations-connectors' );
		$this->action_priority = 40;
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'custom_fields_options', $data );
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'default_fields_options', WFCO_Keap_Common::get_default_fields() );
		}
	}

	public function get_view_data() {
		$custom_fields   = WFCO_Common::get_single_connector_data( $this->connector, 'custom_fields' );
		$optional_fields = [];

		foreach ( $optional_fields as $field ) {
			if ( 'custom_fields' !== $field ) {
				$custom_fields[ $field ] = $field;
			}
		}

		return $custom_fields;
	}

	/**
	 * Show the html fields for the current action.
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>">
            <div class="bwfan-input-form clearfix gs-repeater-fields">
                <div class="bwfan-col-sm-5 bwfan-p-0">
                    <select data-parent-slug="<?php echo esc_attr__( $unique_slug ); ?>" required
                            class="bwfan-input-wrapper wfacp_keap_custom_field" name="bwfan[{{data.action_id}}][data][custom_fields][field][{{data.index}}]">
                        <option value=""><?php echo esc_html__( 'Choose Field', 'autonami-automations-connectors' ); ?></option>
                        <#
                        if(_.has(data.actionFieldsOptions, 'custom_fields_options') && _.isObject(data.actionFieldsOptions.custom_fields_options) ) {
                        _.each( data.actionFieldsOptions.custom_fields_options, function( value, key ){
                        #>
                        <option value="{{key}}">{{value}}</option>
                        <# })
                        }
                        #>
                    </select>
                </div>
                <div class="bwfan-col-sm-6 bwfan-pr-0">
                    <input required type="text" class="bwfan-input-wrapper bwfan-input-merge-tags" value="" name="bwfan[{{data.action_id}}][data][custom_fields][field_value][{{data.index}}]"/>
                </div>
                <div class="bwfan-col-sm-1 bwfan-pr-0">
                    <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                </div>
            </div>
        </script>
        <script type="text/html" id="tmpl-action-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>-2">
            <div class="bwfan-input-form clearfix gs-repeater-fields">
                <div class="bwfan-col-sm-5 bwfan-p-0">
                    <select data-parent-slug="<?php echo esc_attr__( $unique_slug ); ?>" required
                            class="bwfan-input-wrapper wfacp_keap_custom_field" name="bwfan[{{data.action_id}}][data][default_fields][field][{{data.index}}]">
                        <option value=""><?php echo esc_html__( 'Choose Field', 'autonami-automations-connectors' ); ?></option>
                        <#
                        if(_.has(data.actionFieldsOptions, 'default_fields_options') && _.isObject(data.actionFieldsOptions.default_fields_options) ) {
                        _.each( data.actionFieldsOptions.default_fields_options, function( value, key ){
                        #>
                        <option value="{{key}}">{{value}}</option>
                        <# })
                        }
                        #>
                    </select>
                </div>
                <div class="bwfan-col-sm-6 bwfan-pr-0">
                    <input required type="text" class="bwfan-input-wrapper bwfan-input-merge-tags" value="" name="bwfan[{{data.action_id}}][data][default_fields][field_value][{{data.index}}]"/>
                </div>
                <div class="bwfan-col-sm-1 bwfan-pr-0">
                    <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                </div>
            </div>
        </script>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <br/>
            <br/>
            <div class="bwfan-repeater-wrap">
                <label for="" class="bwfan-label-title">
					<?php
					echo esc_html__( 'Select Default Fields', 'autonami-automations-connectors' );
					$message = __( 'Select default fields to update their value', 'autonami-automations-connectors' );
					echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
					echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput
					?>
                </label>
                <div class="clearfix bwfan-input-repeater bwfan_mb10">
                    <#
                    repeaterArr = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'default_fields')) ? data.actionSavedData.data.default_fields : {};
                    repeaterCount = _.size(repeaterArr.field);
                    if(repeaterCount == 0) {
                    repeaterArr = {field:{0:''}, field_value:{0:''}};
                    }

                    if(repeaterCount >= 0) {
                    h=0;
                    _.each( repeaterArr.field, function( key, value ){
                    #>
                    <div class="bwfan-input-form clearfix gs-repeater-fields">
                        <div class="bwfan-col-sm-5 bwfan-p-0">
                            <select required class="bwfan-input-wrapper wfacp_keap_default_field" name="bwfan[{{data.action_id}}][data][default_fields][field][{{h}}]">
                                <option value=""><?php echo esc_html__( 'Choose Field', 'autonami-automations-connectors' ); ?></option>
                                <#
                                if(_.has(data.actionFieldsOptions, 'default_fields_options') && _.isObject(data.actionFieldsOptions.default_fields_options) ) {
                                _.each( data.actionFieldsOptions.default_fields_options, function( column_option_value, column_option_key ){
                                selected = (column_option_key == key) ? 'selected' : '';
                                #>
                                <option value="{{column_option_key}}" {{selected}}>{{column_option_value}}</option>
                                <# })
                                }
                                #>
                            </select>
                        </div>
                        <div class="bwfan-col-sm-6 bwfan-pr-0">
                            <input required type="text" class="bwfan-input-wrapper" value="{{repeaterArr.field_value[value]}}" name="bwfan[{{data.action_id}}][data][default_fields][field_value][{{h}}]"/>
                        </div>
                        <div class="bwfan-col-sm-1 bwfan-pr-0">
                            <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                        </div>
                    </div>
                    <# h++;
                    });
                    }
                    repeaterCount = repeaterCount + 1;
                    #>
                </div>
                <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-mb10">
                    <a href="#" class="bwfan-add-repeater-data bwfan-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>-2" data-groupid="{{data.action_id}}" data-count="{{repeaterCount}}"><?php echo esc_html__( 'Add More', 'autonami-automations-connectors' ); ?></a>
                </div>
            </div>
            <br/>
            <br/>
            <div class="bwfan-repeater-wrap">
                <label for="" class="bwfan-label-title">
					<?php
					echo esc_html__( 'Select Custom Fields', 'autonami-automations-connectors' );
					$message = __( 'Select custom fields to update their value', 'autonami-automations-connectors' );
					echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
					echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput
					?>
                </label>
                <div class="clearfix bwfan-input-repeater bwfan_mb10">
                    <#
                    repeaterArr = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'custom_fields')) ? data.actionSavedData.data.custom_fields : {};
                    repeaterCount = _.size(repeaterArr.field);
                    if(repeaterCount == 0) {
                    repeaterArr = {field:{0:''}, field_value:{0:''}};
                    }

                    if(repeaterCount >= 0) {
                    h=0;
                    _.each( repeaterArr.field, function( key, value ){
                    #>
                    <div class="bwfan-input-form clearfix gs-repeater-fields">
                        <div class="bwfan-col-sm-5 bwfan-p-0">
                            <select required class="bwfan-input-wrapper wfacp_keap_custom_field" name="bwfan[{{data.action_id}}][data][custom_fields][field][{{h}}]">
                                <option value=""><?php echo esc_html__( 'Choose Field', 'autonami-automations-connectors' ); ?></option>
                                <#
                                if(_.has(data.actionFieldsOptions, 'custom_fields_options') && _.isObject(data.actionFieldsOptions.custom_fields_options) ) {
                                _.each( data.actionFieldsOptions.custom_fields_options, function( column_option_value, column_option_key ){
                                selected = (column_option_key == key) ? 'selected' : '';
                                #>
                                <option value="{{column_option_key}}" {{selected}}>{{column_option_value}}</option>
                                <# })
                                }
                                #>
                            </select>
                        </div>
                        <div class="bwfan-col-sm-6 bwfan-pr-0">
                            <input required type="text" class="bwfan-input-wrapper" value="{{repeaterArr.field_value[value]}}" name="bwfan[{{data.action_id}}][data][custom_fields][field_value][{{h}}]"/>
                        </div>
                        <div class="bwfan-col-sm-1 bwfan-pr-0">
                            <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                        </div>
                    </div>
                    <# h++;
                    });
                    }
                    repeaterCount = repeaterCount + 1;
                    #>
                </div>
                <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-mb10">
                    <a href="#" class="bwfan-add-repeater-data bwfan-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>" data-groupid="{{data.action_id}}" data-count="{{repeaterCount}}"><?php echo esc_html__( 'Add More', 'autonami-automations-connectors' ); ?></a>
                </div>
            </div>
        </script>

        <script>
            jQuery(document).ready(function ($) {
                /** Generate repeater UI by calling script template */
                $('body').on('click', '.bwfan-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>', function (event) {
                    event.preventDefault();
                    var $this = $(this);
                    var index = Number($this.attr('data-count'));
                    var action_id = $this.attr('data-groupid');
                    var template = wp.template('action-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>');

                    var actionFieldsOptions = {
                        custom_fields_options: bwfan_set_actions_js_data['<?php echo esc_attr__( $this->get_class_slug() ); ?>']['custom_fields_options']
                    };

                    $this.parents('.bwfan-repeater-wrap').find('.bwfan-input-repeater').append(template({action_id: action_id, index: index, actionFieldsOptions: actionFieldsOptions}));
                    index = index + 1;
                    $this.attr('data-count', index);
                });

                $('body').on('click', '.bwfan-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>-2', function (event) {
                    event.preventDefault();
                    var $this = $(this);
                    var index = Number($this.attr('data-count'));
                    var action_id = $this.attr('data-groupid');
                    var template = wp.template('action-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>-2');

                    var actionFieldsOptions = {
                        default_fields_options: bwfan_set_actions_js_data['<?php echo esc_attr__( $this->get_class_slug() ); ?>']['default_fields_options']
                    };

                    $this.parents('.bwfan-repeater-wrap').find('.bwfan-input-repeater').append(template({action_id: action_id, index: index, actionFieldsOptions: actionFieldsOptions}));
                    index = index + 1;
                    $this.attr('data-count', index);
                });

            });
        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set                 = array();
		$data_to_set['access_token'] = $integration_object->get_settings( 'access_token' );
		$fields                      = $task_meta['data']['custom_fields']['field'];
		$fields_value                = $task_meta['data']['custom_fields']['field_value'];
		$def_fields                  = $task_meta['data']['default_fields']['field'];
		$def_fields_value            = $task_meta['data']['default_fields']['field_value'];
		$custom_fields               = array();
		$default_fields              = array();

		/** Set Email if global email is empty */
		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		if ( $data_to_set ) {
			foreach ( $fields as $key1 => $field_key ) {
				$custom_fields[ $field_key ] = BWFAN_Common::decode_merge_tags( $fields_value[ $key1 ] );
			}

			$date_fields = array( 'anniversary', 'birthday' );
			foreach ( $def_fields as $key => $field_key ) {
				// handling the date field and formatting it in the format required by keap
				if ( in_array( $field_key, $date_fields, true ) ) {
					$def_field_value              = BWFAN_Common::decode_merge_tags( $def_fields_value[ $key ] );
					$default_fields[ $field_key ] = ! empty( $def_field_value ) ? BWFCRM_Contact::get_date_value( $def_field_value, 'Y-m-d' ) : $def_field_value;
					continue;
				}

				$default_fields[ $field_key ] = BWFAN_Common::decode_merge_tags( $def_fields_value[ $key ] );
			}
		}

		$optional_fields = array();
		foreach ( $custom_fields as $key => $field ) {
			if ( 0 === absint( $key ) ) {
				$optional_fields[ $key ] = $field;
				unset( $custom_fields[ $key ] );
			}
		}

		$custom_fields_formatted = array();
		foreach ( $custom_fields as $key => $field ) {
			$custom_fields_formatted[] = array(
				'id'      => $key,
				'content' => $field
			);
		}

		$address_fields = array( 'line1', 'line2', 'locality', 'region', 'postal_code', 'country_code' );
		$address        = [];
		$phone          = [];
		$country_code   = '';
		if ( isset( $default_fields['country_code'] ) && ! empty( $default_fields['country_code'] ) ) {
			// fetching country name if 2 digit iso code is selected in the country formatting
			$country      = 2 === strlen( $default_fields['country_code'] ) ? BWFAN_PRO_Common::get_country_name( $default_fields['country_code'] ) : $default_fields['country_code'];
			$country_code = WFCO_Keap_Common::get_country_iso_code( $country );
		}
		foreach ( $default_fields as $key => $value ) {
			if ( in_array( $key, $address_fields, true ) ) {
				if ( ! empty( $country_code ) && 'country_code' === strval( $key ) ) {
					$address[ $key ] = $country_code;
				} elseif ( ! empty( $country_code ) && 'region' === strval( $key ) ) {
					$region = WFCO_Keap_Common::get_region_code( $value, $country_code );
					if ( ! empty( $region ) ) {
						$address[ $key ] = $region;
					}
				} else {
					$address[ $key ] = $value;
				}
				unset( $default_fields[ $key ] );
				continue;
			}

			if ( 'PHONE1' === $key ) {
				$phone['field']  = $key;
				$phone['number'] = $value;
				unset( $default_fields[ $key ] );
			}
		}

		if ( ! empty( $address ) ) {
			$address['field']         = 'BILLING';
			$data_to_set['addresses'] = array( $address );
		}

		if ( ! empty( $phone ) ) {
			$data_to_set['phone_numbers'] = array( $phone );
		}

		$data_to_set['default_fields']  = $default_fields;
		$data_to_set['custom_fields']   = $custom_fields_formatted;
		$data_to_set['optional_fields'] = $optional_fields;


		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {

		$data_to_set                 = array();
		$data_to_set['access_token'] = isset( $step_data['connector_data']['access_token'] ) ? $step_data['connector_data']['access_token'] : '';

		$data_to_set['email']                  = $automation_data['global']['email'];
		$default_fields                        = $step_data['default_fields'];
		$fields                                = $step_data['custom_fields'];
		$is_validate                           = isset( $step_data['validate_fields'] ) ? $step_data['validate_fields'] : '';
		$data_to_set['mark_status_marketable'] = isset( $step_data['bwfan_keap_contact_status'] ) ? $step_data['bwfan_keap_contact_status'] : 'no';

		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		$default_field_value = [];
		$date_fields         = array( 'anniversary', 'birthday' );
		foreach ( $default_fields as $def_field ) {
			// handling the date field and formatting it in the format required by keap
			if ( in_array( $def_field['field'], $date_fields, true ) ) {
				$def_field_value                            = BWFAN_Common::decode_merge_tags( $def_field['field_value'] );
				$default_field_value[ $def_field['field'] ] = ! empty( $def_field_value ) ? BWFCRM_Contact::get_date_value( $def_field_value, 'Y-m-d' ) : $def_field_value;
				continue;
			}

			$default_field_value[ $def_field['field'] ] = BWFAN_Common::decode_merge_tags( $def_field['field_value'] );
		}

		$custom_fields = [];
		foreach ( $fields as $field ) {
			$custom_fields[ $field['field'] ] = BWFAN_Common::decode_merge_tags( $field['field_value'] );
		}

		//filter custom fields to remove blank
		if ( 1 === intval( $is_validate ) ) {
			foreach ( $custom_fields as $key => $fields ) {
				if ( empty( $fields ) ) {
					unset( $custom_fields[ $key ] );
				}
			}

			foreach ( $default_field_value as $key => $fields ) {
				if ( empty( $fields ) ) {
					unset( $default_field_value[ $key ] );
				}
			}
		}

		$optional_fields = array();
		foreach ( $custom_fields as $key => $field ) {
			if ( 0 === absint( $key ) ) {
				$optional_fields[ $key ] = $field;
				unset( $custom_fields[ $key ] );
			}
		}

		$custom_fields_formatted = array();
		foreach ( $custom_fields as $key => $field ) {
			$custom_fields_formatted[] = array(
				'id'      => $key,
				'content' => $field
			);
		}

		$address_fields = array( 'line1', 'line2', 'locality', 'region', 'postal_code', 'country_code' );
		$address        = [];
		$phone          = [];
		$country_code   = '';
		if ( isset( $default_field_value['country_code'] ) && ! empty( $default_field_value['country_code'] ) ) {
			// fetching country name if 2 digit iso code is selected in the country formatting
			$country      = 2 === strlen( $default_field_value['country_code'] ) ? BWFAN_PRO_Common::get_country_name( $default_field_value['country_code'] ) : $default_field_value['country_code'];
			$country_code = WFCO_Keap_Common::get_country_iso_code( $country );
		}
		foreach ( $default_field_value as $key => $value ) {
			if ( in_array( $key, $address_fields, true ) ) {
				if ( ! empty( $country_code ) && 'country_code' === strval( $key ) ) {
					$address[ $key ] = $country_code;
				} elseif ( ! empty( $country_code ) && 'region' === strval( $key ) ) {
					$region = WFCO_Keap_Common::get_region_code( $value, $country_code );
					if ( ! empty( $region ) ) {
						$address[ $key ] = $region;
					}
				} else {
					$address[ $key ] = $value;
				}
				unset( $default_field_value[ $key ] );
				continue;
			}

			if ( 'PHONE1' === $key ) {
				$phone['field']  = $key;
				$phone['number'] = $value;
				unset( $default_field_value[ $key ] );
			}
		}

		if ( ! empty( $address ) ) {
			$address['field']         = 'BILLING';
			$data_to_set['addresses'] = array( $address );
		}

		if ( ! empty( $phone ) ) {
			$data_to_set['phone_numbers'] = array( $phone );
		}

		$data_to_set['default_fields']  = $default_field_value;
		$data_to_set['custom_fields']   = $custom_fields_formatted;
		$data_to_set['optional_fields'] = $optional_fields;

		return $data_to_set;
	}

	protected function handle_response( $result, $call_object = null ) {
		if ( isset( $result['status'] ) ) {
			return $result;
		}

		if ( isset( $result['response'] ) && 200 === absint( $result['response'] ) ) {
			return array(
				'status'  => 3,
				'message' => __( 'Custom fields updated successfully!', 'autonami-automations-connectors' ),
			);
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return array(
				'status'  => 4,
				'message' => isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ),
			);
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$fault_message   = isset( $result['body']['fault'] ) ? $result['body']['fault']['faultstring'] : false;
		$message         = isset( $result['body']['message'] ) ? $result['body']['message'] : false;
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return array(
			'status'  => 4,
			'message' => ( false !== $fault_message ? $fault_message : ( false !== $message ? $message : $unknown_message ) ) . $response_code,
		);
	}

	public function handle_response_v2( $result ) {

		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		if ( isset( $result['response'] ) && ( 200 === absint( $result['response'] ) || 201 === absint( $result['response'] ) ) ) {
			return $this->success_message( __( 'Contact created successfully!', 'autonami-automations-connectors' ) );
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return $this->error_response( isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$fault_message   = isset( $result['body']['fault'] ) ? $result['body']['fault']['faultstring'] : false;
		$message         = isset( $result['body']['message'] ) ? $result['body']['message'] : false;
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return $this->error_response( ( false !== $fault_message ? $fault_message : ( false !== $message ? $message : $unknown_message ) ) . $response_code );

	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$field_options         = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $this->get_view_data() ) );
		$default_field_options = BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], WFCO_Keap_Common::get_default_fields() ) );

		return [
			[
				'id'          => 'default_fields',
				'type'        => 'repeater',
				'label'       => __( 'Select Default Fields', 'autonami-automations-connectors' ),
				"fields"      => [
					[
						'id'          => 'field',
						'type'        => 'select',
						'options'     => $default_field_options,
						'placeholder' => 'Select',
						'label'       => "",
						'tip'         => "",
						"description" => "",
						"required"    => false,
					],
					[
						"id"          => 'field_value',
						"label"       => "",
						"type"        => 'text',
						"class"       => 'bwfan-input-wrapper',
						"description" => "",
						"required"    => false,
					]
				],
				'tip'         => __( "Select default fields to update their value.", 'autonami-automations-connectors' ),
				"description" => ""
			],
			[
				'id'          => 'custom_fields',
				'type'        => 'repeater',
				'label'       => __( 'Select Custom Fields', 'autonami-automations-connectors' ),
				"fields"      => [
					[
						'id'          => 'field',
						'type'        => 'select',
						'options'     => $field_options,
						'placeholder' => 'Select',
						'label'       => "",
						'tip'         => "",
						"description" => "",
						"required"    => false,
					],
					[
						"id"          => 'field_value',
						"label"       => "",
						"type"        => 'text',
						"class"       => 'bwfan-input-wrapper',
						"description" => "",
						"required"    => false,
					]
				],
				'tip'         => __( "Select custom fields to update their value.", 'autonami-automations-connectors' ),
				"description" => ""
			],
			[
				'id'            => 'validate_fields',
				'type'          => 'checkbox',
				'label'         => '',
				'checkboxlabel' => __( 'Do not update default and custom field(s) when passed value is blank', 'autonami-automations-connectors' ),
				"description"   => ""
			],
			[
				'id'          => 'bwfan_keap_contact_status',
				'label'       => __( 'Mark Contact as Marketable', 'autonami-automations-connectors' ),
				'type'        => 'radio',
				'options'     => [
					[
						'label' => 'Yes',
						'value' => 'yes'
					],
					[
						'label' => 'No',
						'value' => 'no'
					],
				],
				"class"       => 'bwfan-input-wrapper',
				"tip"         => "",
				"required"    => false,
				"description" => "",
			],
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );

		if ( ! isset( $data['custom_fields'] ) || empty( $data['custom_fields'] ) ) {
			return '';
		}

		$count = count( $data['custom_fields'] );

		return ( $count > 1 ) ? $count . ' fields' : $count . ' field';
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Keap_Update_Contact_Fields';
