<?php

#[AllowDynamicProperties]
final class BWFAN_Klaviyo_Update_Profile_fields extends BWFAN_Action {

	private static $ins = null;

	private function __construct() {
		$this->action_name     = __( 'Update Fields', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action adds/ updates the custom fields of the contact', 'autonami-automations-connectors' );
		$this->action_priority = 20;
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_assets' ), 98 );
	}

	/**
	 * Localize data for html fields for the current action.
	 */
	public function admin_enqueue_assets() {
		if ( BWFAN_Common::is_load_admin_assets( 'automation' ) ) {
			$data = $this->get_view_data();
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'fields_options', $data['fields'] );
			BWFAN_Core()->admin->set_actions_js_data( $this->get_class_slug(), 'lists', $data['lists'] );
		}
	}

	public function get_view_data() {
		$lists  = WFCO_Common::get_single_connector_data( $this->connector, 'lists' );
		$fields = $this->pre_define_fields();

		return [ 'lists' => $lists, 'fields' => $fields ];
	}

	public function pre_define_fields() {
		return [
			'email'        => 'Email',
			'first_name'   => 'First Name',
			'last_name'    => 'Last Name',
			'organization' => 'Organization',
			'title'        => 'Title',
			'city'         => 'City',
			'region'       => 'Region',
			'zip'          => 'Zip',
			'country'      => 'Country',
			'phone_number' => 'Phone Number',
		];
	}

	/**
	 * Show the html fields for the current action.
	 */
	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>">
            <div class="bwfan-input-form clearfix gs-repeater-fields">
                <div class="bwfan-col-sm-5 bwfan-p-0">
                    <select data-parent-slug="<?php echo esc_attr__( $unique_slug ); ?>" required
                            class="bwfan-input-wrapper wfacp_ac_custom_field" name="bwfan[{{data.action_id}}][data][predefine_fields][field][{{data.index}}]">
                        <option value=""><?php echo esc_html__( 'Choose Field', 'autonami-automations-connectors' ); ?></option>
                        <#
                        if(_.has(data.actionFieldsOptions, 'fields_options') && _.isObject(data.actionFieldsOptions.fields_options) ) {
                        _.each( data.actionFieldsOptions.fields_options, function( value, key ){
                        #>
                        <option value="{{key}}">{{value}}</option>
                        <# })
                        }
                        #>
                    </select>
                </div>
                <div class="bwfan-col-sm-6 bwfan-pr-0">
                    <input required type="text" class="bwfan-input-wrapper bwfan-input-merge-tags" value="" name="bwfan[{{data.action_id}}][data][predefine_fields][field_value][{{data.index}}]"/>
                </div>
                <div class="bwfan-col-sm-1 bwfan-pr-0">
                    <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                </div>
            </div>
        </script>
        <script type="text/html" id="tmpl-action-repeater-ui-<?php echo esc_html__( $unique_slug ); ?>-2">
            <div class="bwfan-input-form clearfix gs-repeater-fields">
                <div class="bwfan-col-sm-5 bwfan-pl-0">
                    <input required type="text" class="bwfan-input-wrapper" value="" name="bwfan[{{data.action_id}}][data][custom_fields][field][{{data.index}}]"/>
                </div>
                <div class="bwfan-col-sm-6 bwfan-pr-0">
                    <input required type="text" class="bwfan-input-wrapper bwfan-input-merge-tags" value="" name="bwfan[{{data.action_id}}][data][custom_fields][field_value][{{data.index}}]"/>
                </div>
                <div class="bwfan-col-sm-1 bwfan-pr-0">
                    <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                </div>
            </div>
        </script>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#
            sms_consent = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'sms_consent')) ? data.actionSavedData.data.sms_consent : [];
            is_sms_consent = _.contains(sms_consent,"sms")?"checked":"";
            #>
            <div class="bwfan-repeater-wrap">
                <label for="" class="bwfan-label-title">
					<?php
					echo esc_html__( 'Select Fields', 'autonami-automations-connectors' );
					$message = __( 'Select custom fields to update their value', 'autonami-automations-connectors' );
					echo $this->add_description( $message, '2xl', 'right' ); //phpcs:ignore WordPress.Security.EscapeOutput
					echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput
					?>
                </label>
                <div class="clearfix bwfan-input-repeater bwfan_mb10">
                    <#
                    repeaterArr = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'predefine_fields')) ? data.actionSavedData.data.predefine_fields : {};
                    repeaterCount = _.size(repeaterArr.field);
                    validate_field = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'validate_fields')) ? data.actionSavedData.data.validate_fields : 0;

                    validate_field = 1=== parseInt(validate_field)?'checked':0;
                    if(repeaterCount == 0) {
                    repeaterArr = {field:{0:''}, field_value:{0:''}};
                    }

                    if(repeaterCount >= 0) {
                    h=0;
                    _.each( repeaterArr.field, function( value, key ){
                    #>
                    <div class="bwfan-input-form clearfix gs-repeater-fields">
                        <div class="bwfan-col-sm-5 bwfan-p-0">
                            <select required class="bwfan-input-wrapper wfacp_ac_custom_field" name="bwfan[{{data.action_id}}][data][predefine_fields][field][{{h}}]">
                                <option value=""><?php echo esc_html__( 'Choose Field', 'autonami-automations-connectors' ); ?></option>
                                <#
                                if(_.has(data.actionFieldsOptions, 'fields_options') && _.isObject(data.actionFieldsOptions.fields_options) ) {
                                _.each( data.actionFieldsOptions.fields_options, function( column_option_value, column_option_key ){
                                selected = (column_option_key == value) ? 'selected' : '';
                                #>
                                <option value="{{column_option_key}}" {{selected}}>{{column_option_value}}</option>
                                <# })
                                }
                                #>
                            </select>
                        </div>
                        <div class="bwfan-col-sm-6 bwfan-pr-0">
                            <input required type="text" class="bwfan-input-wrapper" value="{{repeaterArr.field_value[key]}}" name="bwfan[{{data.action_id}}][data][predefine_fields][field_value][{{h}}]"/>
                        </div>
                        <div class="bwfan-col-sm-1 bwfan-pr-0">
                            <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                        </div>
                    </div>
                    <# h++;
                    });
                    }
                    repeaterCount = repeaterCount + 1;
                    #>
                </div>
                <div class="bwfan-col-sm-12 bwfan-pl-0">
                    <a href="#" class="bwfan-add-repeater-data bwfan-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>" data-groupid="{{data.action_id}}" data-count="{{repeaterCount}}"><?php echo esc_html__( 'Add More', 'autonami-automations-connectors' ); ?></a>
                </div>
            </div>
            <br/>
            <br/>
            <div class="bwfan-repeater-wrap">
                <label for="" class="bwfan-label-title"><?php echo esc_html__( 'Enter Custom Field Key/ values', 'woofunnels-connector' ); ?></label>
                <div class="clearfix bwfan-input-repeater bwfan-mb10">
                    <#
                    repeaterArr = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'custom_fields')) ? data.actionSavedData.data.custom_fields : {};
                    repeaterCount = _.size(repeaterArr.field);
                    if(repeaterCount == 0) {
                    repeaterArr = {field:{0:''}, field_value:{0:''}};
                    }

                    if(repeaterCount >= 0) {
                    h=0;
                    _.each( repeaterArr.field, function( value, key ){
                    #>
                    <div class="bwfan-input-form clearfix gs-repeater-fields">
                        <div class="bwfan-col-sm-5 bwfan-pl-0">
                            <input required type="text" class="bwfan-input-wrapper" value="{{repeaterArr.field[key]}}" name="bwfan[{{data.action_id}}][data][custom_fields][field][{{h}}]"/>
                        </div>
                        <div class="bwfan-col-sm-6 bwfan-pr-0">
                            <input required type="text" class="bwfan-input-wrapper" value="{{repeaterArr.field_value[key]}}" name="bwfan[{{data.action_id}}][data][custom_fields][field_value][{{h}}]"/>
                        </div>
                        <div class="bwfan-col-sm-1 bwfan-pr-0">
                            <span class="bwfan-remove-repeater-field" data-groupid="{{data.action_id}}">&#10006;</span>
                        </div>
                    </div>
                    <# h++;
                    });
                    }
                    repeaterCount = repeaterCount + 1;
                    #>
                </div>

                <script>
                    jQuery(document).ready(function ($) {
                        /** Generate repeater UI by calling script template */
                        $('body').on('click', '.bwfan-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>', function (event) {
                            event.preventDefault();
                            var $this = $(this);
                            var index = Number($this.attr('data-count'));
                            var action_id = $this.attr('data-groupid');
                            var template = wp.template('action-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>');

                            var actionFieldsOptions = {
                                fields_options: bwfan_set_actions_js_data['<?php echo esc_attr__( $this->get_class_slug() ); ?>']['fields_options']
                            };

                            $this.parents('.bwfan-repeater-wrap').find('.bwfan-input-repeater').append(template({action_id: action_id, index: index, actionFieldsOptions: actionFieldsOptions}));
                            index = index + 1;
                            $this.attr('data-count', index);
                        });
                        $('body').on('click', '.bwfan-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>-2', function (event) {
                            event.preventDefault();
                            var $this = $(this);
                            var index = Number($this.attr('data-count'));
                            var action_id = $this.attr('data-groupid');
                            var template = wp.template('action-repeater-ui-<?php echo esc_attr__( $unique_slug ); ?>-2');

                            var actionFieldsOptions = {
                                fields_options: bwfan_set_actions_js_data['<?php echo esc_attr__( $this->get_class_slug() ); ?>']['fields_options']
                            };

                            $this.parents('.bwfan-repeater-wrap').find('.bwfan-input-repeater').append(template({action_id: action_id, index: index, actionFieldsOptions: actionFieldsOptions}));
                            index = index + 1;
                            $this.attr('data-count', index);
                        });
                    });
        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set            = array();
		$data_to_set['api_key'] = $integration_object->get_settings( 'api_key' );

		$fields       = $task_meta['data']['predefine_fields']['field'];
		$fields_value = $task_meta['data']['predefine_fields']['field_value'];

		$custom_fields       = $task_meta['data']['custom_fields']['field'];
		$custom_fields_value = $task_meta['data']['custom_fields']['field_value'];

		$profile_fields = array();
		$is_validate    = isset( $task_meta['data']['validate_fields'] ) ? $task_meta['data']['validate_fields'] : '';

		/** Set Email if global email is empty */
		$data_to_set['email'] = $task_meta['global']['email'];
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $task_meta['global']['user_id'] ) ? get_user_by( 'ID', $task_meta['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		if ( $data_to_set ) {
			foreach ( $fields as $key1 => $field_alias ) {
				$profile_fields[ $field_alias ] = BWFAN_Common::decode_merge_tags( $fields_value[ $key1 ] );
			}
			foreach ( $custom_fields as $key => $field_alias ) {
				$profile_fields[ $field_alias ] = BWFAN_Common::decode_merge_tags( $custom_fields_value[ $key ] );
			}
		}

		/** set country code in case of order and  cart abandoned event */
		if ( isset( $task_meta['global'] ) && isset( $task_meta['global']['order_id'] ) ) {
			$data_to_set['order_id'] = $task_meta['global']['order_id'];
		} elseif ( isset( $task_meta['global'] ) && isset( $task_meta['global']['cart_abandoned_id'] ) ) {
			$data_to_set['cart_abandoned_id'] = $task_meta['global']['cart_abandoned_id'];
		}

		//filter profile fields to remove blank
		if ( 1 === intval( $is_validate ) ) {
			foreach ( $custom_fields as $key => $fields ) {
				if ( empty( $fields ) ) {
					unset( $custom_fields[ $key ] );
				}
			}
		}

		$data_to_set['profile_fields'] = $profile_fields;

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {

		$data_to_set            = array();
		$data_to_set['api_key'] = isset( $step_data['connector_data']['api_key'] ) ? $step_data['connector_data']['api_key'] : '';
		$data_to_set['email']   = $automation_data['global']['email'];
		$fields                 = isset( $step_data['custom_fields'] ) ? $step_data['custom_fields'] : '';
		$predefine_fields       = $step_data['predefine_fields'];
		$is_validate            = isset( $step_data['validate_fields'] ) ? $step_data['validate_fields'] : '';

		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		$custom_field = [];
		if ( ! empty( $fields ) ) {
			foreach ( $fields as $field ) {
				$value = BWFAN_Common::decode_merge_tags( $field['field_value'] );

				/** If validate field setting is enabled  */
				if ( 1 === intval( $is_validate ) && empty( $value ) ) {
					continue;

				}

				$custom_field[ $field['field'] ] = $value;
			}
		}

		$predefine_location_fields = [ 'address1', 'address2', 'city', 'country', 'region', 'zip' ];
		$profile_fields            = [];
		$location_fields           = [];
		if ( ! empty( $predefine_fields ) ) {
			foreach ( $predefine_fields as $field ) {
				$value = BWFAN_Common::decode_merge_tags( $field['field_value'] );

				/** If validate field setting is enabled  */
				if ( 1 === intval( $is_validate ) && empty( $value ) ) {
					continue;

				}

				if ( in_array( $field['field'], $predefine_location_fields, true ) ) {
					$location_fields[ $field['field'] ] = $value;
					continue;
				}
				$profile_fields[ $field['field'] ] = $value;
			}
		}

		$data_to_set['profile_fields']  = $profile_fields;
		$data_to_set['custom_fields']   = $custom_field;
		$data_to_set['location_fields'] = $location_fields;

		return $data_to_set;
	}

	protected function handle_response( $result, $call_object = null ) {
		return $result;
	}

	public function handle_response_v2( $result ) {
		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		/** If success (within 200 status), then return payload (actual response) and status, message */
		if ( ( absint( $result['response'] ) - 200 ) < 100 ) {
			return $this->success_message( __( 'Klaviyo API call executed successfully', 'autonami-automations-connectors' ) );
		}

		$klaviyo_error = "";
		$unknown_error = "";

		/** If failed, send appropriate error */
		$response_code = __( '. Error Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		if ( isset( $result['body']['message'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['message'] . ', Code: ' . $result['response'];
		}
		if ( isset( $result['body']['detail'] ) ) {
			$klaviyo_error = __( 'Klaviyo Error: ', 'autonami-automations-connectors' ) . $result['body']['detail'] . ', Code: ' . $result['response'];
		}

		if ( empty( $klaviyo_error ) ) {
			$unknown_error = __( 'Unknown Klaviyo Error', 'autonami-automations-connectors' ) . $response_code;
		}

		return $this->error_response( ( false !== $klaviyo_error ? $klaviyo_error : $unknown_error ) );
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		$data          = $this->get_view_data();
		$field_options = isset( $data['fields'] ) && is_array( $data['fields'] ) ? BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $data['fields'] ) ) : [];
		$lists         = isset( $data['lists'] ) && is_array( $data['lists'] ) ? BWFAN_PRO_Common::prepared_field_options( array_replace( [ '' => 'Select' ], $data['lists'] ) ) : [];

		return [
			[
				'id'          => 'predefine_fields',
				'type'        => 'repeater',
				'label'       => __( 'Select Predefine Fields', 'autonami-automations-connectors' ),
				"fields"      => [
					[
						'id'          => 'field',
						'type'        => 'select',
						'options'     => $field_options,
						'placeholder' => 'Select',
						'label'       => "",
						'tip'         => "",
						"description" => "",
						"required"    => false,
					],
					[
						"id"          => 'field_value',
						"label"       => "",
						"type"        => 'text',
						"class"       => 'bwfan-input-wrapper',
						"description" => "",
						"required"    => false,
					]
				],
				'tip'         => __( "Select predefine fields to update their value.", 'autonami-automations-connectors' ),
				"description" => ""
			],
			[
				'id'          => 'custom_fields',
				'type'        => 'repeater',
				'label'       => __( 'Enter Custom Field Key/ values', 'autonami-automations-connectors' ),
				"fields"      => [
					[
						'id'          => 'field',
						'type'        => 'text',
						'label'       => "",
						'tip'         => "",
						"description" => "",
						"required"    => false,
					],
					[
						"id"          => 'field_value',
						"label"       => "",
						"type"        => 'text',
						"class"       => 'bwfan-input-wrapper',
						"description" => "",
						"required"    => false,
					]
				],
				'tip'         => __( "", 'autonami-automations-connectors' ),
				"description" => ""
			],
			[
				'id'            => 'validate_fields',
				'type'          => 'checkbox',
				'label'         => '',
				'checkboxlabel' => __( 'Do not update custom field(s) when passed value is blank', 'autonami-automations-connectors' ),
				"description"   => ""
			]
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );

		$count = ( isset( $data['predefine_fields'] ) && count( $data['predefine_fields'] ) > 0 ) ? count( $data['predefine_fields'] ) : 0;
		$count = ( isset( $data['custom_fields'] ) && count( $data['custom_fields'] ) > 0 ) ? $count + count( $data['custom_fields'] ) : $count;

		if ( empty( $count ) ) {
			return '';
		}

		return ( $count > 1 ) ? $count . ' fields' : $count . ' field';
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Klaviyo_Update_Profile_fields';
