<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Add_Profile extends WFCO_Klaviyo_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct( [ 'api_key', 'email' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_add_profile';
	}

	public function process_klaviyo_call() {

		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$user_data = array(
			'type'       => 'profile',
			'attributes' => array(
				'email' => $this->data['email']
			)
		);

		if ( isset( $this->data['profile_fields'] ) && is_array( $this->data['profile_fields'] ) && ! empty( $this->data['profile_fields'] ) ) {
			$user_data['attributes'] = array_merge( $user_data['attributes'], $this->data['profile_fields'] );
		}

		if ( ! empty( $this->data['phone'] ) ) {
			$user_data['attributes']['phone_number'] = $this->data['phone'];
		}

		$user_data['attributes'] = array_filter( $user_data['attributes'] );
		if ( ! empty( $this->data['location_fields'] ) ) {
			$user_data['attributes']['location'] = $this->data['location_fields'];
		}

		$params = array(
			'data' => $user_data
		);

		return $this->do_klaviyo_call( wp_json_encode( $params ), \BWF_CO::$POST );
	}


	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Klaviyo::$api_end_point . 'profiles/';

	}

}

return 'WFCO\Klaviyo\Add_Profile';
