<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Update_List_Subscribe_Status extends WFCO_Klaviyo_Call {

	private static $ins = null;
	private $api_params = [];

	public function __construct() {
		parent::__construct( [ 'api_key', 'email' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_update_list_subscribe_status';
	}

	public function process_klaviyo_call() {
		if ( isset( $this->data['email'] ) && ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}
		$connectors = \WFCO_Load_Connectors::get_instance();
		$call       = $connectors->get_call( 'wfco_klaviyo_get_profile' );
		$call->set_data( $this->data );
		$profile = $call->process();

		if ( empty( $profile ) ) {
			/** Create Profile */
			$call = $connectors->get_call( 'wfco_klaviyo_add_profile' );
			$call->set_data( $this->data );
			$profile = $call->process();
			if ( isset( $profile['status'] ) && 4 === $profile['status'] ) {
				return $this->get_autonami_error( $profile['message'] );
			}
		}

		if ( empty( $profile ) ) {
			return $this->get_autonami_error( __( 'profile is not found ', 'autonami-automations-connectors' ) );
		}

		$is_email_subscribed = isset( $profile['payload']['data'][0]['attributes']['subscriptions']['email']['marketing']['consent'] ) ? $profile['payload']['data'][0]['attributes']['subscriptions']['email']['marketing']['consent'] : '';
		$is_sms_subscribed   = isset( $profile['payload']['data'][0]['attributes']['subscriptions']['sms']['marketing']['consent'] ) ? $profile['payload']['data'][0]['attributes']['subscriptions']['sms']['marketing']['consent'] : '';

		$actions = [];
		/** For unsubscribe */
		if ( ( empty( $this->data['email_consent'] ) && 'SUBSCRIBED' === $is_email_subscribed ) || empty( $this->data['sms_consent'] ) && 'SUBSCRIBED' === $is_sms_subscribed ) {
			$actions[] = 'unsubscribe';
		}

		/** If email or sms consent is enable then subscribe */
		if ( ( ! empty( $this->data['email_consent'] ) && 'SUBSCRIBED' !== $is_email_subscribed ) || ( ! empty( $this->data['sms_consent'] ) && 'SUBSCRIBED' !== $is_sms_subscribed ) ) {
			$actions[] = 'subscribe';
		}

		/** If no action to perform  */
		if ( empty( $actions ) ) {
			return array(
				'status'  => 3,
				'message' => __( 'Klaviyo API call executed successfully', 'autonami-automations-connectors' )
			);
		}

		$profile_status_call = $connectors->get_call( 'wfco_klaviyo_change_profile_status' );
		$res                 = '';
		foreach ( $actions as $action ) {
			$this->data['action'] = $action;

			$profile_status_call->set_data( $this->data );
			$res = $profile_status_call->process();
		}

		return $res;
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return '';
	}
}

return 'WFCO\Klaviyo\Update_List_Subscribe_Status';
