<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Update_Profile_fields extends WFCO_Klaviyo_Call {

	private static $ins = null;
	private $api_params = [];
	private $profile_id = null;

	public function __construct() {
		parent::__construct( [ 'api_key', 'email' ] );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_update_profile_fields';
	}

	public function process_klaviyo_call() {
		if ( isset( $this->data['email'] ) && ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}

		$this->profile_id = $this->get_profile_id( $this->data );
		if ( empty( $this->profile_id ) || is_array( $this->profile_id ) ) {
			$message = isset( $this->profile_id['message'] ) ? $this->profile_id['message'] : __( 'profile is not found ', 'autonami-automations-connectors' );

			return $this->get_autonami_error( $message );
		}

		$params = [
			'data' => [
				'type'       => 'profile',
				'id'         => $this->profile_id,
				'attributes' => [
					'email' => $this->data['email'],
				],
			],
		];

		$profileFields = [
			'phone_number',
			'first_name',
			'last_name',
			'organization',
			'title',
		];

		foreach ( $profileFields as $field ) {
			if ( isset( $this->data['profile_fields'][ $field ] ) && ! empty( $this->data['profile_fields'][ $field ] ) ) {
				$params['data']['attributes'][ $field ] = $this->data['profile_fields'][ $field ];
			}
		}
		$properties = [
			'order_id'          => isset( $this->data['order_id'] ) ? $this->data['order_id'] : '',
			'cart_abandoned_id' => isset( $this->data['cart_abandoned_id'] ) ? $this->data['cart_abandoned_id'] : '',
			'bwfan_con_source'  => 'autonami',
		];

		if ( ! empty( $this->data['custom_fields'] ) ) {
			$properties = array_merge( $properties, $this->data['custom_fields'] );
		}

		if ( ! empty( $properties ) ) {
			$params['data']['attributes']['properties'] = $properties;
		}

		/** Add location field to update */
		if ( ! empty( $this->data['location_fields'] ) ) {
			$params['data']['attributes']['location'] = $this->data['location_fields'];
		}


		return $this->do_klaviyo_call( wp_json_encode( $params ), \BWF_CO::$PATCH );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		if ( empty( $this->profile_id ) ) {
			$profile          = $this->get_profile_id( $this->data );
			$this->profile_id = isset( $profile['payload']['data'][0]['id'] ) ? $profile['payload']['data'][0]['id'] : 0;
		}

		$url = \BWFCO_Klaviyo::$api_end_point . 'profiles/' . $this->profile_id;

		return add_query_arg( $this->api_params, $url );
	}

	public function get_profile_id( $data ) {
		$connector_ins = \WFCO_Load_Connectors::get_instance();
		$call          = $connector_ins->get_call( 'wfco_klaviyo_get_profile' );
		$call->set_data( $data );
		$profile = $call->process();

		$person_id = isset( $profile['payload']['data'][0]['id'] ) ? $profile['payload']['data'][0]['id'] : 0;

		if ( empty( $person_id ) ) {
			/** Create Profile */
			$call = $connector_ins->get_call( 'wfco_klaviyo_add_profile' );
			$call->set_data( $this->data );
			$result = $call->process();
			if ( isset( $result['status'] ) && 4 === $result['status'] ) {
				return $this->get_autonami_error( $result['message'] );
			}
			$person_id = isset( $result['payload']['data']['id'] ) ? $result['payload']['data']['id'] : 0;
		}

		return $person_id;
	}

}

return 'WFCO\Klaviyo\Update_Profile_fields';
