<?php

namespace WFCO\MailerLite;

#[\AllowDynamicProperties]
class Get_Group_List extends WFCO_Mailerlite_Call {

	private static $ins = null;

	public function __construct() {
		parent::__construct();
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_mailerlite_get_group_list';
	}

	public function process_mailerlite_call() {
		$offset = isset( $this->data['offset'] ) ? $this->data['offset'] : 0;
		$params = [ 'limit' => 50, 'offset' => $offset, 'bwfan_con_source' => 'autonami', 'method' => 'get' ];

		return $this->do_mailerlite_call( $params, \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Mailerlite::$api_end_point . 'groups';
	}

}

return 'WFCO\MailerLite\Get_Group_List';
