<?php


$saved_connectors = WFCO_Common::$connectors_saved_data;

if ( empty( $saved_connectors ) ) {
	WFCO_Common::get_connectors_data();
	$saved_connectors = WFCO_Common::$connectors_saved_data;
}

if ( array_key_exists( 'bwfco_twilio', $saved_connectors ) ) {
    #[AllowDynamicProperties]
	class BWFAN_Rule_Twilio_SMS_Body_Text_Match extends BWFAN_Rule_Base {

		public function __construct() {
			$this->v2 = true;
			parent::__construct( 'twilio_sms_body_text_match' );
		}

		public function conditions_view() {
			$condition_input_type = $this->get_condition_input_type();
			$values               = $this->get_possible_rule_values();
			$value_args           = array(
				'input'       => $condition_input_type,
				'name'        => 'bwfan_rule[<%= groupId %>][<%= ruleId %>][condition]',
				'choices'     => $values,
				'placeholder' => __( 'Enter Few Characters...', 'autonami-automations' ),
			);

			bwfan_Input_Builder::create_input_field( $value_args );
		}

		public function get_condition_input_type() {
			return 'Text';
		}

		public function get_possible_rule_values() {
			return null;
		}

		public function is_match_v2( $automation_data, $rule_data ) {
			if ( ! isset( $automation_data['global'] ) || ! is_array( $automation_data['global'] ) || ! isset( $automation_data['global']['twilio_data'] ) || empty( $automation_data['global']['twilio_data'] ) ) {
				return $this->return_is_match( false, $rule_data );
			}

			$twilio_data = $automation_data['global']['twilio_data'];

			if ( ! is_array( $twilio_data ) || ! isset( $twilio_data['Body'] ) ) {
				return $this->return_is_match( false, $rule_data );
			}

			return $this->return_is_match( BWFAN_Common::validate_string( $twilio_data['Body'], $rule_data['rule'], trim( $rule_data['data'] ) ), $rule_data );
		}

		public function is_match( $rule_data ) {
			$twilio_data = BWFAN_Core()->rules->getRulesData( 'twilio_data' );
			$values      = [];
			$values[]    = isset( $twilio_data['Body'] ) && ! empty( $twilio_data['Body'] ) ? $twilio_data['Body'] : '';

			return $this->return_is_match( BWFAN_Common::validate_string_multi( $values, $rule_data['operator'], $rule_data['condition'] ), $rule_data );
		}

		public function ui_view() {
			?>
            SMS body text
            <% var ops = JSON.parse('<?php echo wp_json_encode( $this->get_possible_rule_operators() ); ?>'); %>

            <%= ops[operator] %>
            <%= condition %>
			<?php
		}

		public function get_possible_rule_operators() {
			return array(
				'contains'    => __( 'any contains', 'autonami-automations-connectors' ),
				'is'          => __( 'any matches exactly', 'autonami-automations-connectors' ),
				'starts_with' => __( 'starts with', 'autonami-automations-connectors' ),
				'ends_with'   => __( 'ends with', 'autonami-automations-connectors' ),
			);
		}
	}
}
