<?php

/**
 *
 * Class BWFAN_Hubspot_Message_Received\
 */
#[AllowDynamicProperties]
final class BWFAN_Hubspot_Message_Received extends BWFAN_Event {
	private static $instance = null;
	private $hubspot_id = null;
	private $automation_key = '';
	private $localized_automation_key = '';
	private $hubspot_data = array();

	private function __construct() {
		$this->optgroup_label         = __( 'Hubspot', 'autonami-automations' );
		$this->event_name             = __( 'Webhook Received', 'autonami-automations' );
		$this->event_desc             = __( 'This automation would trigger webhook.', 'autonami-automations' );
		$this->event_merge_tag_groups = array( 'hubspot_contact', 'bwf_contact' );
		$this->event_rule_groups      = array(
			'bwf_contact_segments',
			'bwf_contact_fields',
			'bwf_contact',
			'bwf_contact_user',
			'bwf_contact_wc',
			'bwf_contact_geo',
			'bwf_engagement',
			'bwf_broadcast'
		);
		$this->customer_email_tag     = '{{hubspot_contact_email}}';
		$this->v2                     = true;
		$this->need_unique_key        = true;
	}

	public function load_hooks() {
		add_action( 'admin_enqueue_scripts', array( $this, 'bwfan_webhook_admin_enqueue_assets' ), 98 );
		add_action( "bwfan_hubspot_connector_sync_call", array( $this, 'before_process_webhook_contact' ), 10, 3 );

		add_action( 'bwfan_webhook_hubspot_received', array( $this, 'process' ), 10, 3 );
	}

	public function before_process_webhook_contact( $automation_id, $automation_key, $request_data ) {
		$hook  = 'bwfan_webhook_hubspot_received';
		$args  = array(
			'hubspot_data'   => $request_data,
			'automation_key' => $automation_key,
			'automation_id'  => $automation_id
		);
		$group = 'hubspot';

		if ( bwf_has_action_scheduled( $hook, $args, $group ) ) {
			return;
		}
		bwf_schedule_single_action( time(), $hook, $args, $group );

	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function get_email_event() {
		return isset( $this->hubspot_data['email'] ) && is_email( $this->hubspot_data['email'] ) ? $this->hubspot_data['email'] : false;
	}

	public function get_user_id_event() {

		$email = isset( $this->hubspot_data['email'] ) && is_email( $this->hubspot_data['email'] ) ? $this->hubspot_data['email'] : false;
		$user  = false !== $email ? get_user_by( 'email', $email ) : false;

		return $user instanceof WP_User ? $user->user_email : false;
	}

	public function bwfan_webhook_admin_enqueue_assets() {
		$this->hubspot_id = isset( $_GET['edit'] ) ? sanitize_text_field( $_GET['edit'] ) : ''; //phpcs:ignore WordPress.Security.NonceVerification
		if ( ! empty( $this->hubspot_id ) ) {
			$meta = BWFAN_Model_Automationmeta::get_meta( $this->hubspot_id, 'event_meta' );
			if ( isset( $meta['bwfan_unique_key'] ) && ! empty( $meta['bwfan_unique_key'] ) ) {
				$this->localized_automation_key = $meta['bwfan_unique_key'];
			}
		}

		BWFAN_Core()->admin->set_events_js_data( $this->get_slug(), 'automation_id', $this->hubspot_id );
		BWFAN_Core()->admin->set_events_js_data( $this->get_slug(), 'saved_localized_automation_key', $this->localized_automation_key );
	}

	/**
	 * Make the view data for the current event which will be shown in task listing screen.
	 *
	 * @param $global_data
	 *
	 * @return false|string
	 */
	public function get_task_view( $global_data ) {
		ob_start();

		if ( ! is_array( $global_data['hubspot_data'] ) || empty( $global_data['hubspot_data'] ) ) {
			?>
            <li>
                <strong><?php esc_html_e( 'No Data Available', 'autonami-automations-connectors' ); ?> </strong>
            </li>
			<?php
			return ob_get_clean();
		}

		$data_to_show = array(
			'vid'   => 'Hubspot ID',
			'email' => 'Email'
		);

		foreach ( $data_to_show as $key => $alias ) {

			if ( ! isset( $global_data['hubspot_data'][ $key ] ) || empty( $global_data['hubspot_data'][ $key ] ) ) {
				continue;
			}
			?>
            <li>
                <strong><?php esc_html_e( "$alias: " ); ?></strong>
				<?php esc_html_e( $global_data['hubspot_data'][ $key ] ); ?>
            </li>
			<?php

		}

		return ob_get_clean();
	}

	/**
	 * Show the html fields for the current event.
	 */
	public function get_view( $db_eventmeta_saved_value ) {

		?>
        <script type="text/html" id="tmpl-event-<?php esc_attr_e( $this->get_slug() ); ?>">
            <#
            var eventslug = '<?php esc_html_e( $this->get_slug() ); ?>';
            var eventData = bwfan_events_js_data[eventslug];
            var event_save_unique_key =eventData.saved_localized_automation_key;
            if(event_save_unique_key.length>0){
            eventData.localized_automation_key = event_save_unique_key
            }
            var webhook_url = '<?php esc_attr_e( home_url( '/' ) ); ?>wp-json/autonami/v1/hubspot/webhook?hubspot_id='+eventData.automation_id+'&hubspot_key='+eventData.localized_automation_key;
            #>
            <div class="bwfan_mt15"></div>
            <label for="bwfan-webhook-url" class="bwfan-label-title"><?php esc_html_e( 'URL', 'autonami-automations-connectors' ); ?></label>
            <div class="bwfan-textarea-box">
                <textarea name="event_meta[bwfan_webhook_url]" class="bwfan-input-wrapper bwfan-webhook-url" id="bwfan-webhook-url" cols="45" rows="2" onclick="select();" readonly>{{webhook_url}}</textarea>
                <input type="hidden" name="event_meta[bwfan_unique_key]" id="bwfan-unique-key" value={{eventData.localized_automation_key}}>
            </div>
        </script>
		<?php
	}

	public function process( $hubspot_data, $automation_key, $automation_id ) {
		$data                   = $this->get_default_data();
		$data['hubspot_id']     = $automation_id;
		$data['automation_key'] = $automation_key;

		$email                 = isset( $hubspot_data['email'] ) ? $hubspot_data['email'] : '';
		$hubspot_data['email'] = empty( $email ) && isset( $hubspot_data['properties']['email']['value'] ) ? $hubspot_data['properties']['email']['value'] : $email;
		$data['email']         = empty( $email ) && isset( $hubspot_data['properties']['email']['value'] ) ? $hubspot_data['properties']['email']['value'] : $email;

		$data['hubspot_data'] = $hubspot_data;

		$this->send_async_call( $data );
	}

	/**
	 * Capture the async data for the current event.
	 * @return array|bool
	 */
	public function capture_async_data() {
		$this->hubspot_id     = BWFAN_Common::$events_async_data['hubspot_id'];
		$this->automation_key = BWFAN_Common::$events_async_data['automation_key'];
		$this->hubspot_data   = BWFAN_Common::$events_async_data['hubspot_data'];

		return $this->run_automations();
	}

	/**
	 * A controller function to run automation every time an appropriate event occurs
	 * usually called by the event class just after the event hook to load all automations and run.
	 * @return array|bool
	 */
	public function run_automations() {
		BWFAN_Core()->public->load_active_automations( $this->get_slug() );
		if ( ! is_array( $this->automations_arr ) || count( $this->automations_arr ) === 0 ) {
			if ( $this->sync_start_time > 0 ) {
				/** Sync process */
				BWFAN_Core()->logger->log( 'Sync #' . $this->sync_id . '. No active automations found for Event ' . $this->get_slug(), 'sync' );

				return false;
			}
			BWFAN_Core()->logger->log( 'Async callback: No active automations found. Event - ' . $this->get_slug(), $this->log_type );

			return false;
		}

		$automation_actions = [];
		$ran_actions        = 0;
		foreach ( $this->automations_arr as $automation_id => $automation_data ) {
			if ( $this->get_slug() !== $automation_data['event'] || 0 !== intval( $automation_data['requires_update'] ) ) {
				continue;
			}
			//check if the automation_key match with the post data
			if ( isset( $automation_data['event_meta']['bwfan_unique_key'] ) && $this->automation_key === $automation_data['event_meta']['bwfan_unique_key'] ) {
				$ran_actions = $this->handle_single_automation_run( $automation_data, $automation_id );
			}


			$automation_actions[ $automation_id ] = $ran_actions;
		}

		return $automation_actions;
	}

	/**
	 * Registers the tasks for current event.
	 *
	 * @param $automation_id
	 * @param $integration_data
	 * @param $event_data
	 */
	public function register_tasks( $automation_id, $integration_data, $event_data ) {
		if ( ! is_array( $integration_data ) ) {
			return;
		}

		$meta = BWFAN_Model_Automationmeta::get_meta( $automation_id, 'event_meta' );

		if ( '' === $meta || ! is_array( $meta ) ) {
			return;
		}

		$data_to_send = $this->get_event_data();
		$this->create_tasks( $automation_id, $integration_data, $event_data, $data_to_send );
	}

	public function get_event_data() {
		$data_to_send                             = [];
		$data_to_send['global']['hubspot_id']     = $this->hubspot_id;
		$data_to_send['global']['automation_key'] = $this->automation_key;
		$data_to_send['global']['hubspot_data']   = $this->hubspot_data;
		$data_to_send['global']['email']          = $this->get_email_event();

		return $data_to_send;
	}

	public function set_merge_tags_data( $task_meta ) {
		$merge_data                 = [];
		$merge_data['hubspot_data'] = $task_meta['global']['hubspot_data'];
		$merge_data['email']        = $task_meta['global']['email'];
		BWFAN_Merge_Tag_Loader::set_data( $merge_data );
	}

	/**
	 * Capture the async data for the current event.
	 * @return array|bool
	 */
	public function capture_v2_data( $automation_data ) {

		$this->hubspot_id     = BWFAN_Common::$events_async_data['hubspot_id'];
		$this->automation_key = BWFAN_Common::$events_async_data['automation_key'];
		$this->hubspot_data   = BWFAN_Common::$events_async_data['hubspot_data'];

		$automation_data['hubspot_id']     = $this->hubspot_id;
		$automation_data['automation_key'] = $this->automation_key;
		$automation_data['hubspot_data']   = $this->hubspot_data;

		return $automation_data;
	}

	public function get_fields_schema() {
		return [
			[
				'id'          => 'bwfan_email_map_key',
				'type'        => 'webhook',
				'label'       => __( 'Select Email Field', 'autonami-automations-connectors' ),
				'webhook_url' => rest_url( 'autonami/v1/hubspot/webhook/' ) . '?hubspot_id={{automationId}}&hubspot_key={{uniqueKey}}',
				'required'    => false,
				'hint'        => "",
				'showmap'     => false,
			]
		];
	}

}

/**
 * Register this event to a source.
 * This will show the current event in dropdown in single automation screen.
 */
$saved_connectors = WFCO_Common::$connectors_saved_data;

if ( empty( $saved_connectors ) ) {
	WFCO_Common::get_connectors_data();
	$saved_connectors = WFCO_Common::$connectors_saved_data;
}

if ( array_key_exists( 'bwfco_hubspot', $saved_connectors ) ) {
	return 'BWFAN_Hubspot_Message_Received';
}