<?php

namespace WFCO\HubSpot;

#[\AllowDynamicProperties]
class Update_Contact extends WFCO_Hubspot_Call {

	private static $ins = null;
	private $contact_id = null;

	public function __construct() {
		parent::__construct( array( 'api_key', 'email', 'contact_fields' ) );
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_hubspot_update_contact';
	}

	public function process_hubspot_call() {
		if ( ! is_email( $this->data['email'] ) ) {
			return $this->get_autonami_error( __( 'Email is not valid', 'autonami-automations-connectors' ) );
		}
		$this->contact_id = $this->get_contact_by_email();

		if ( empty( $this->contact_id ) ) {
			$contact = $this->create_contact();
			if ( 4 == $contact['status'] ) {
				return $this->get_autonami_error( $contact['message'] );
			}
			$this->contact_id = $contact['payload']['id'];
		}

		$params['properties']       = $this->data['contact_fields'];
		$params['bwfan_con_source'] = 'autonami';

		\BWFCO_Hubspot::set_headers( $this->data['api_key'] );

		return $this->do_hubspot_call( wp_json_encode( $params ), \BWF_CO::$PATCH );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return \BWFCO_Hubspot::$api_end_point . 'crm/v3/objects/contacts/' . $this->contact_id;
	}

}

return 'WFCO\HubSpot\Update_Contact';
