<?php

#[AllowDynamicProperties]
final class BWFAN_Keap_Create_Contact extends BWFAN_Action {

	private static $instance = null;

	private function __construct() {
		$this->action_name     = __( 'Create Contact', 'autonami-automations-connectors' );
		$this->action_desc     = __( 'This action creates a contact', 'autonami-automations-connectors' );
		$this->action_priority = 10;
		$this->support_v2      = true;
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function get_view() {
		$unique_slug = $this->get_slug();
		?>
        <script type="text/html" id="tmpl-action-<?php echo esc_attr__( $unique_slug ); ?>">
            <#

            email_merge_tag ='';
            if (typeof selected_event_src !== 'undefined') {
            ae = bwfan_automation_data.all_triggers_events;
            if(_.has(ae, selected_event_src) &&
            _.has(ae[selected_event_src], selected_event) &&
            _.has(ae[selected_event_src][selected_event], 'customer_email_tag')) {
            email_merge_tag = ae[selected_event_src][selected_event].customer_email_tag;
            }
            }

            selected_first_name = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'first_name')) ? data.actionSavedData.data.first_name : '';
            selected_last_name = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'last_name')) ? data.actionSavedData.data.last_name : '';
            selected_email = (_.has(data.actionSavedData, 'data') && _.has(data.actionSavedData.data, 'email')) ? data.actionSavedData.data.email : email_merge_tag;
            #>

            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'Email', 'autonami-automations-connectors' ); ?>
				<?php echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input required type="text" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][email]" placeholder="Email" value="{{selected_email}}"/>
            </div>
            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'First Name (optional)', 'autonami-automations-connectors' ); ?>
				<?php echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input required type="text" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][first_name]" placeholder="First Name" value="{{selected_first_name}}"/>
            </div>
            <label for="" class="bwfan-label-title">
				<?php esc_html_e( 'Last Name (optional)', 'autonami-automations-connectors' ); ?>
				<?php echo $this->inline_merge_tag_invoke(); //phpcs:ignore WordPress.Security.EscapeOutput ?>
            </label>
            <div class="bwfan-col-sm-12 bwfan-pl-0 bwfan-pr-0 bwfan-mb-15">
                <input required type="text" class="bwfan-input-wrapper bwfan-field-<?php esc_html_e( $unique_slug ); ?>" name="bwfan[{{data.action_id}}][data][last_name]" placeholder="Last Name" value="{{selected_last_name}}"/>
            </div>
        </script>
		<?php
	}

	/**
	 * Make all the data which is required by the current action.
	 * This data will be used while executing the task of this action.
	 *
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array|void
	 */
	public function make_data( $integration_object, $task_meta ) {
		$data_to_set                 = array();
		$data_to_set['access_token'] = $integration_object->get_settings( 'access_token' );
		$data_to_set['first_name']   = BWFAN_Common::decode_merge_tags( $task_meta['data']['first_name'] );
		$data_to_set['last_name']    = BWFAN_Common::decode_merge_tags( $task_meta['data']['last_name'] );
		$data_to_set['email']        = BWFAN_Common::decode_merge_tags( $task_meta['data']['email'] );

		return $data_to_set;
	}

	public function make_v2_data( $automation_data, $step_data ) {
		$data_to_set                           = array();
		$data_to_set['access_token']           = isset( $step_data['connector_data']['access_token'] ) ? $step_data['connector_data']['access_token'] : '';
		$data_to_set['first_name']             = BWFAN_Common::decode_merge_tags( $step_data['first_name'] );
		$data_to_set['last_name']              = BWFAN_Common::decode_merge_tags( $step_data['last_name'] );
		$data_to_set['email']                  = BWFAN_Common::decode_merge_tags( $step_data['email'] );
		$data_to_set['mark_status_marketable'] = isset( $step_data['bwfan_keap_contact_status'] ) ? $step_data['bwfan_keap_contact_status'] : 'no';

		/** Set Email if global email is empty */
		if ( empty( $data_to_set['email'] ) ) {
			$user = ! empty( $automation_data['global']['user_id'] ) ? get_user_by( 'ID', $automation_data['global']['user_id'] ) : false;

			$data_to_set['email'] = $user instanceof WP_User ? $user->user_email : '';
		}

		return $data_to_set;
	}

	protected function handle_response( $result, $call_object = null ) {
		if ( isset( $result['status'] ) ) {
			return $result;
		}

		if ( isset( $result['response'] ) && ( 200 === absint( $result['response'] ) || 201 === absint( $result['response'] ) ) ) {
			return array(
				'status'  => 3,
				'message' => __( 'Contact created successfully!', 'autonami-automations-connectors' ),
			);
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return array(
				'status'  => 4,
				'message' => isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ),
			);
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$fault_message   = isset( $result['body']['fault'] ) ? $result['body']['fault']['faultstring'] : false;
		$message         = isset( $result['body']['message'] ) ? $result['body']['message'] : false;
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return array(
			'status'  => 4,
			'message' => ( false !== $fault_message ? $fault_message : ( false !== $message ? $message : $unknown_message ) ) . $response_code,
		);
	}

	public function handle_response_v2( $result ) {

		if ( isset( $result['status'] ) ) {
			$message = isset( $result['message'] ) ? $result['message'] : __( 'Unknown API Exception', 'autonami-automations-connectors' );
			if ( 4 === absint( $result['status'] ) ) {
				return $this->error_response( $message );
			}

			return $this->success_message( $message );
		}

		if ( isset( $result['response'] ) && ( 200 === absint( $result['response'] ) || 201 === absint( $result['response'] ) ) ) {
			return $this->success_message( __( 'Contact created successfully!', 'autonami-automations-connectors' ) );
		}

		if ( 502 === absint( $result['response'] ) && is_array( $result['body'] ) ) {
			return $this->error_response( isset( $result['body'][0] ) ? $result['body'][0] : __( 'Unknown FunnelKit Automations Error', 'autonami-automations-connectors' ) );
		}

		$response_code   = __( '. Response Code: ', 'autonami-automations-connectors' ) . $result['response'];
		$fault_message   = isset( $result['body']['fault'] ) ? $result['body']['fault']['faultstring'] : false;
		$message         = isset( $result['body']['message'] ) ? $result['body']['message'] : false;
		$unknown_message = __( 'Unknown API Exception', 'autonami-automations-connectors' );

		return $this->error_response( ( false !== $fault_message ? $fault_message : ( false !== $message ? $message : $unknown_message ) ) . $response_code );

	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		return [
			[
				'id'          => 'email',
				'label'       => __( "Email", 'autonami-automations-connectors' ),
				'type'        => 'text',
				'placeholder' => "Email",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
			[
				'id'          => 'first_name',
				'label'       => __( "First Name", 'autonami-automations-connectors' ),
				'type'        => 'text',
				'placeholder' => "First Name",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => false,
			],
			[
				'id'          => 'last_name',
				'label'       => __( "Last Name", 'autonami-automations-connectors' ),
				'type'        => 'text',
				'placeholder' => "Last Name",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => false,
			],
			[
				'id'          => 'bwfan_keap_contact_status',
				'label'       => __( 'Mark Contact as Marketable', 'autonami-automations-connectors' ),
				'type'        => 'radio',
				'options'     => [
					[
						'label' => 'Yes',
						'value' => 'yes'
					],
					[
						'label' => 'No',
						'value' => 'no'
					],
				],
				"class"       => 'bwfan-input-wrapper',
				"tip"         => "",
				"required"    => false,
				"description" => "",
			],
		];
	}

	public function get_desc_text( $data ) {
		$data = json_decode( wp_json_encode( $data ), true );
		if ( ! isset( $data['email'] ) || empty( $data['email'] ) ) {
			return '';
		}

		return $data['email'];
	}
}

/**
 * Register this action. Registering the action will make it eligible to see it on single automation screen in select actions dropdown.
 */
return 'BWFAN_Keap_Create_Contact';
