<?php

namespace WFCO\Klaviyo;

#[\AllowDynamicProperties]
class Get_Lists extends WFCO_Klaviyo_Call {

	private static $ins = null;
	public $endpoint = null;

	public function __construct() {
		$this->endpoint = \BWFCO_Klaviyo::$api_end_point . 'lists';
		parent::__construct();
	}

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_klaviyo_get_lists';
	}

	public function process_klaviyo_call() {
		return $this->do_klaviyo_call( [], \BWF_CO::$GET );
	}

	/**
	 * Return the endpoint.
	 *
	 * @return string
	 */
	public function get_endpoint( $endpoint_var = '' ) {
		return $this->endpoint;
	}

}

return 'WFCO\Klaviyo\Get_Lists';
