<?php

namespace WFCO\BulkGate;

/**
 * Class WFCO_Bulkgate_Shorten_Url
 */
#[\AllowDynamicProperties]
class Shorten_Url extends \WFCO_Call {
	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'application_id', 'application_token', 'url' );
		$this->api_end_point   = 'https://portal.bulkgate.com/api/1.0/shortener/shorten';
	}

	/**
	 * @return Shorten_Url|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_bulkgate_shorten_url';
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'application_id'    => $this->data['application_id'],
			'application_token' => $this->data['application_token'],
			'target_url'        => $this->data['url']
		);

		/** Checking if header is not set */
		if ( empty( \BWFCO_Bulkgate::get_headers() ) ) {
			\BWFCO_Bulkgate::set_headers();
		}

		return $this->make_wp_requests( $this->api_end_point, wp_json_encode( $params ), \BWFCO_Bulkgate::get_headers(), \BWF_CO::$POST );
	}

}

return 'WFCO\BulkGate\Shorten_Url';
